---
name: vk-client-search-repetitor
description: Автоматический поиск клиентов (родителей) для репетитора по математике в группах ВКонтакте с умной фильтрацией и приоритизацией онлайн-запросов.
version: 1.0.0
author: OpenClaw @Danil4091
permissions:
  - internet_access
  - file_system_read_write
  - schedule_task
---

# Поиск клиентов для репетитора (VK Monitor)

## 1. Description
Этот скилл предназначен для репетиторов по математике. Он автоматизирует рутинный процесс поиска учеников в социальных сетях. Агент мониторит заданный список сообществ ВКонтакте (группы для мам, доски объявлений, сообщества по поиску репетиторов), фильтрует рекламный спам от коллег-репетиторов и выделяет целевые запросы от родителей. Особое внимание уделяется запросам на онлайн-обучение. Результаты сохраняются в структурированный файл, а пользователь получает сводный отчет.

## 2. When to use
Скилл активируется при следующих запросах пользователя:
- "Найди клиентов для репетитора в ВК"
- "Кто ищет репетитора по математике онлайн?"
- "Собери запросы на репетиторство в группах"
- "Запусти мониторинг учеников по математике"
- "Найди родителей, которые ищут репетитора для ЕГЭ"
- "Поиск клиентов в ВК с приоритетом на онлайн"

## 3. How to use

Выполни следующую последовательность действий:

### Шаг 1: Инициализация и получение данных
1. **Проверь наличие конфигурации**: Убедись, что пользователь предоставил `VK Service Token` (или попроси ввести его).
2. **Получи список групп**: Запроси у пользователя список URL или ID групп ВКонтакте (10-15 шт.), если они не заданы ранее.
3. **Настрой расписание**: Установи таймер повторения задачи на каждые **3 часа**.

### Шаг 2: Сбор данных (Iterative Process)
Для каждой группы из списка:
1. Используй метод API `wall.get` (для стен) или парсинг HTML, чтобы получить последние 20-30 постов.
2. *Опционально:* Если это группа-обсуждение, проверь последние комментарии в актуальных ветках.

### Шаг 3: Анализ и Фильтрация
Для каждого поста/комментария примени логику:

**А. Фильтр "Анти-спам" (Исключение коллег)**
Если текст содержит фразы: *"предлагаю услуги", "набираю учеников", "мой стаж", "первое занятие бесплатно", "помогу с..."* — **ПРОПУСТИТЬ** (это реклама другого репетитора).

**Б. Поиск ключевых слов (Match Logic)**
Приведи текст к нижнему регистру и ищи совпадения:

* **Группа 1 (База):** "репетитор", "математик", "ищу репетитора", "нужен репетитор", "помогите с математикой", "подтянуть", "алгебра", "геометрия".
* **Группа 2 (Приоритет - Онлайн):** "онлайн", "скайп", "skype", "zoom", "зум", "дистанционно", "удаленно".
* **Группа 3 (Маркеры качества):** "ЕГЭ", "ОГЭ", "олимпиада", "поступление", "ДВИ", "физмат", "лицей", "цена не важна".

**В. Определение приоритета**
* **ВЫСОКИЙ:** Найдены слова из Группы 1 **И** Группы 2.
* **ВЫСОКИЙ:** Найдены слова из Группы 1 **И** "цена не важна".
* **СРЕДНИЙ:** Найдены только слова из Группы 1.
* **НИЗКИЙ/ИГНОР:** Ключевых слов нет.

### Шаг 4: Сохранение данных
Если найдено совпадение (Средний или Высокий приоритет):
1. Проверь, нет ли уже этой ссылки в базе (избегай дублей).
2. Сформируй запись и добавь её в файл `leads_math.csv` (или Google Sheet, если подключен).
   
**Формат записи:**
`Дата_Время | Название_Группы | Ссылка_на_пост | Имя_Автора | Текст_Запроса (первые 100 симв.) | Ключевики | Приоритет | Статус`
*Примечание: Поле "Статус" по умолчанию заполнять значением "НОВЫЙ".*

### Шаг 5: Отчетность
После завершения цикла проверки всех групп сгенерируй краткий отчет для пользователя.

## 4. Configuration

Для корректной работы пользователю необходимо предоставить:

1.  **VK_API_TOKEN**: Сервисный ключ доступа приложения (Service Token) для чтения открытых стен.
2.  **TARGET_GROUPS**: Список ID групп (например: `[-123456, -987654]`) или ссылок. Рекомендуются группы: "Подслушано [Город]", "Мамочки [Город]", "Репетиторы поиск", "Биржа репетиторов".
3.  **OUTPUT_PATH**: Путь к файлу для сохранения (по умолчанию: `./vk_leads_data.csv`).

## 5. Edge cases

* **Группа закрыта/удалена:** Залогировать ошибку "Ошибка доступа к группе [ID]", продолжить проверку следующих групп. Не прерывать работу.
* **Лимит запросов API (Too Many Requests):** Если VK API возвращает ошибку лимита, сделать паузу на 60 секунд и повторить запрос.
* **Нет новых постов:** Если за 3 часа в группах нет новых релевантных постов, отправить отчет: "Проверено [N] групп. Новых заявок не найдено."
* **Слишком длинный текст поста:** В таблицу сохранять только первые 150-200 символов, чтобы не ломать верстку CSV.

## 6. Example output

**Пример отчета после цикла проверки:**

```text
✅ Мониторинг завершен (14:00)
Проверено групп: 12
Пример строки в CSV:

2023-10-25 14:05;Мамы Москва;https://vk.com/wall-123_456;Анна Петрова;Ищем репетитора для ЕГЭ, только Zoom, мальчик 11 класс;репетитор, егэ, zoom;ВЫСОКИЙ;НОВЫЙ
-----------------------------------
🔍 Найдены новые лиды:
1. [ВЫСОКИЙ] "Ищем репетитора для ЕГЭ, только Zoom..." (Группа: Мамы Москва)
2. [ВЫСОКИЙ] "Нужен препод по алгебре 8 класс, дистан..." (Группа: Репетиторы РФ)
3. [СРЕДНИЙ] "Кто может подтянуть геометрию?" (Группа: Подслушано Саратов)

Всего новых: 3
Данные сохранены в leads_math.csv
Следующая проверка: 17:00
---

### 💡 Рекомендация по использованию
Чтобы этот скилл работал максимально эффективно, попроси пользователя добавить список конкретных групп-доноров. Лучше всего работают локальные группы "Мамочки [Район/Город]" и специализированные паблики "Поиск репетитора", где открыта стена или комментарии.