# Visual Vocabulary

Use precise design terminology instead of generic words. This reference helps generate prompts with professional visual language.

## Color

| Instead of | Use |
|-----------|-----|
| red | crimson, vermillion, scarlet, carmine, ruby, burgundy, coral |
| blue | cobalt, cerulean, navy, indigo, azure, slate, teal, prussian |
| green | emerald, sage, olive, chartreuse, forest, mint, jade, viridian |
| yellow | amber, gold, saffron, marigold, ochre, canary, mustard |
| purple | violet, plum, amethyst, lavender, mauve, aubergine, lilac |
| white | ivory, pearl, cream, bone, chalk, snow, alabaster |
| black | onyx, obsidian, charcoal, jet, ink, ebony, pitch |
| gray | slate, ash, pewter, graphite, smoke, silver, stone |

### Color Relationships
- **Monochromatic**: Single hue, varying saturation and value
- **Complementary**: Opposing hues on the color wheel
- **Analogous**: Adjacent hues, harmonious
- **Triadic**: Three equidistant hues, vibrant
- **Split-complementary**: Base + two adjacent to complement
- **Muted**: Desaturated, grayed tones
- **Saturated**: Pure, vivid, high-chroma

## Composition

| Term | Description |
|------|-------------|
| Rule of thirds | Subject at intersection points |
| Golden ratio | Spiral-based placement |
| Centered/symmetrical | Subject dead center, balanced |
| Asymmetric balance | Unequal weight, visual tension |
| Leading lines | Lines guide eye to subject |
| Frame within frame | Natural borders around subject |
| Negative space | Empty area as design element |
| Bleeding edge | Elements extend beyond canvas |
| Stacked | Vertical layering of elements |
| Grid | Structured rows and columns |
| Scattered | Intentionally dispersed elements |
| Radial | Elements emanate from center |
| Diagonal | Dynamic angled arrangement |
| Z-pattern | Eye follows Z across canvas |
| F-pattern | Eye follows F (top-heavy) |

## Lighting

| Term | Description |
|------|-------------|
| Rembrandt | Triangle of light on shadowed cheek |
| Chiaroscuro | Strong light-dark contrast |
| Rim light | Edge lighting from behind |
| Diffused | Soft, even, no harsh shadows |
| Directional | Single clear light source |
| Ambient | Surrounding environmental light |
| Backlit | Light behind subject (silhouette potential) |
| Top-down | Overhead light source |
| Under-lit | Light from below (dramatic/unnatural) |
| Volumetric | Visible light rays through atmosphere |
| Neon | Colored artificial light sources |
| Golden hour | Warm, low-angle natural light |
| Overcast | Flat, cool, shadowless |
| High-key | Predominantly bright, few shadows |
| Low-key | Predominantly dark, selective highlights |
| Caustics | Light refracted through transparent objects |

## Texture

| Term | Description |
|------|-------------|
| Glassmorphism | Frosted glass, blur, transparency |
| Grain/noise | Film-like granular texture |
| Matte | Non-reflective, flat surface |
| Glossy | Reflective, shiny surface |
| Metallic | Chrome, brushed metal, foil |
| Paper/fiber | Organic, tactile, handmade feel |
| Concrete/stone | Raw, industrial, mineral |
| Liquid | Fluid, flowing, mercury-like |
| Fabric | Woven, knit, draped textile |
| Wood grain | Natural, warm, organic pattern |
| Embossed | Raised surface pattern |
| Debossed | Indented surface pattern |
| Halftone | Dot-based printing pattern |
| Stippled | Point-based texture |
| Weathered | Aged, worn, patinated |
| Crystalline | Faceted, prismatic, gem-like |

## Typography (as visual element)

| Term | Description |
|------|-------------|
| Condensed | Narrow letter width |
| Extended | Wide letter width |
| Slab serif | Thick, blocky serifs |
| Hairline | Ultra-thin strokes |
| Display | Decorative, attention-grabbing |
| Monospace | Fixed-width, technical feel |
| Script | Handwritten, flowing |
| Blackletter | Gothic, medieval |
| Geometric sans | Clean, circle/square based (Futura, Avenir) |
| Humanist sans | Warm, calligraphic influence (Gill Sans) |
| Stencil | Cut-out letter forms |
| Variable weight | Transitioning thickness |

## Depth and Space

| Term | Description |
|------|-------------|
| Flat | No depth, 2D plane |
| Layered | Multiple z-depth planes |
| Isometric | 3D without perspective convergence |
| Parallax | Layers move at different speeds |
| Tilt-shift | Selective focus simulating miniature |
| Forced perspective | Scale manipulation through angle |
| Atmospheric perspective | Distant objects fade/blue |
| Deep field | Everything in sharp focus |
| Shallow field | Narrow focus plane, bokeh |
| Overlapping | Elements stacked in z-space |

## Mood Descriptors (Precise)

| Generic (avoid) | Precise alternatives |
|-----------------|---------------------|
| Beautiful | Refined, polished, harmonious, elegant |
| Cool | Detached, icy, clinical, austere |
| Warm | Inviting, intimate, cozy, amber-toned |
| Dark | Brooding, noir, somber, ominous |
| Light | Airy, buoyant, weightless, luminous |
| Modern | Stripped-back, functional, current, sleek |
| Old | Weathered, nostalgic, patinated, archival |
| Fun | Whimsical, irreverent, bouncy, saturated |
| Serious | Austere, restrained, monumental, grave |
| Calm | Still, meditative, hushed, serene |
| Energetic | Kinetic, charged, pulsing, explosive |
