# Prompt Patterns

Rotate through these patterns to generate diverse, non-repetitive image prompts. Never use the same pattern twice in a row. Track the last pattern used in `data/prompt_history.json`.

## Pattern 1: Color-First

Lead with the color palette, let it define the entire mood.

```
A [composition] scene dominated by [hex colors from palette]. 
[Subject] rendered in [texture] with [lighting]. 
The overall feel is [mood].
```

## Pattern 2: Emotion-Driven

Start from the emotional target, work backward to visuals.

```
Capture the feeling of [mood] through [subject].
Use [composition] framing with [contrast] contrast.
Color palette: [palette]. Surface: [texture].
```

## Pattern 3: Material Study

Focus on textures and materials as the hero.

```
[Subject] crafted from [texture/material].
Shot in [lighting] light, [composition] layout.
Palette restricted to [2-3 colors from palette].
[Depth] perspective with [contrast] tonal range.
```

## Pattern 4: Negative Space

Define what is NOT in the image as much as what is.

```
[Subject] isolated in [negative space description].
Minimal palette: [1-2 colors]. [Composition] alignment.
[Lighting] creates [mood]. No [explicitly exclude common cliches].
```

## Pattern 5: Cinematic Frame

Treat the image as a film still.

```
Film still: [subject] in [setting].
Shot on [camera/lens description]. [Lighting] lighting.
Color graded with [palette] tones. [Mood] atmosphere.
[Depth] with [bokeh/focus description].
```

## Pattern 6: Typography-Informed

Let typographic principles guide the visual structure.

```
[Subject] arranged with [typography-inspired] rhythm.
Visual weight distributed [composition description].
[Palette] with [contrast] contrast between elements.
[Texture] surfaces under [lighting].
```

## Pattern 7: Opposing Forces

Build tension through contrasting elements.

```
[Element A] meets [Element B]: [subject].
[Warm color] against [cool color]. [Organic texture] on [geometric form].
[Lighting] emphasizes the boundary. [Mood A] clashing with [Mood B].
```

## Pattern 8: Time of Day

Anchor the entire visual in a specific moment.

```
[Time of day]: [subject] bathed in [time-appropriate lighting].
[Palette adjusted to time]. [Composition] framing.
The air feels [texture/atmosphere]. [Mood] pervades.
```

## Pattern 9: Scale Play

Manipulate scale to create interest.

```
[Macro/micro] view of [subject].
[Tiny/massive] details reveal [texture].
[Palette] at this scale. [Lighting] from [unexpected direction].
[Composition] emphasizes the [scale relationship].
```

## Pattern 10: Cultural Reference

Root the visual in a specific design movement or era.

```
In the style of [design movement]: [subject].
[Era-appropriate palette]. [Movement-typical composition].
[Texture] reminiscent of [historical reference].
Modern interpretation with [contemporary element].
```

## Pattern 11: Sensory Crossover

Describe non-visual senses to inspire the visual.

```
[Subject] that looks like it [sounds/feels/tastes/smells] like [sensory description].
[Texture] surface. [Palette] evoking [sensation].
[Lighting] as [sensory metaphor]. [Composition] arrangement.
```

## Pattern 12: Deconstructed

Break the subject into abstract components.

```
[Subject] deconstructed into [abstract elements].
[Palette] fragments. [Composition] scattered/arranged.
[Texture] on individual pieces. [Lighting] reveals structure.
[Mood] through [arrangement pattern].
```

## Anti-Patterns (Avoid)

- Generic superlatives: "beautiful", "stunning", "amazing", "gorgeous"
- Vague atmosphere: "ethereal", "dreamy" without specifics
- Overused combos: "neon + cyberpunk", "sunset + silhouette", "bokeh + portrait"
- Empty modifiers: "hyper-realistic", "ultra-detailed", "8K" (unless specifically needed)
- Repetitive structures: starting every prompt with "A [adjective] [noun]"
