---
name: visual-file-sorter
description: 自动遍历下载文件夹或桌面，利用视觉模型“看”文件内容并重命名，最后归档到指定分类目录。
version: 1.0.0
author: Local_User
permissions:
  filesystem:
    read: ["~/Downloads", "~/Desktop"]
    write: ["~/Documents/Sorted"]
  shell:
    allowed: true
---

# 视觉系文件分类大师 (Visual File Sorter)

## 🎯 核心目标
你的任务是作为一个本地数字管家，自动清理用户杂乱的“下载 (Downloads)”或“桌面 (Desktop)”文件夹。你需要完全模拟人类“双击打开 -> 查阅内容 -> 总结命名 -> 拖拽归档”的物理工作流。

## 💡 触发条件
当用户发送类似以下指令时触发此工作流：
* “帮我整理一下下载文件夹”
* “归档桌面上的杂乱文件”
* “执行桌面清理”



## 📋 执行步骤

### 第一步：获取待处理队列
1. 使用终端工具列出目标文件夹（默认 `~/Downloads`）中的所有文件。
2. 自动过滤并跳过系统隐藏文件（如 `.DS_Store`）和正在下载的临时文件（如 `.crdownload`, `.part`）。

### 第二步：模拟人类视觉阅读（核心循环）
针对队列中的每一个文件，严格执行以下动作：
1. **打开文件：** 使用操作系统的默认程序或命令（如 Mac 的 `open`，Windows 的 `start`）打开该文件。
2. **视觉抓取：** 等待 1-2 秒确保软件 UI 渲染完成。使用你的**屏幕视觉能力 (Computer Use - Vision)** 截取当前屏幕，阅读并理解文件内容。
3. **内容提炼：** 在后台分析该文件是什么（如：餐饮发票、租房合同、搞笑表情包、技术 PDF）。提取关键元数据（如发票日期、公司名称、主要内容）。
4. **关闭窗口：** 模拟按下关闭快捷键（如 `Cmd+W` 或 `Alt+F4`），退出预览界面。

### 第三步：智能重命名
基于上一步的视觉分析结果，按以下规则生成新的文件名，并使用 Shell 命令执行重命名：
* **财务报销类（发票/收据）：** `[YYYY-MM]_发票_[公司或摘要].[扩展名]`
* **工作/正式文档：** `[YYYY-MM-DD]_[文档核心主题].[扩展名]`
* **图片/多媒体素材：** `[画面内容描述].[扩展名]`
* *异常处理：如果内容无法识别或受密码保护，保留原文件名，并在前缀加上 `未分类_`。*

### 第四步：物理归档
检查目标归档目录 `~/Documents/Sorted/` 是否存在，如果不存在则自动创建。随后将重命名后的文件移动到以下对应的子文件夹中：
* `.../Sorted/财务账单/`
* `.../Sorted/工作文档/`
* `.../Sorted/图片素材/`
* `.../Sorted/其他未分类/`

## ⚠️ 安全与操作红线
1. **禁止删除：** 你仅拥有重命名和移动的权限。无论文件看起来多么像“垃圾文件”，绝对不允许执行 `rm` 或将其移入回收站。
2. **扩展名保护：** 严禁修改文件的后缀名（扩展名），哪怕你认为它是一个伪装的文件，也只能修改 `.` 之前的文件名部分。
3. **隐私隔离：** 视觉识别必须依赖本地或默认的视觉大模型通道，不得擅自编写脚本将截图或文本内容发送到未授权的第三方外部 API。