---
name: visual-essay-engine
description: Transform AIGC images into a structured visual essay with narrative sequencing, bilingual captions, artist statements, and Instagram-ready packaging.
version: 1.0.2
metadata:
  openclaw:
    emoji: "🧠"
---

# Visual Essay Engine

Visual Essay Engine (VEE) is a structural content production skill.

It upgrades scattered AI-generated images into a coherent visual essay system — complete with narrative architecture, bilingual minimal captions, and publishing-ready packaging.
---

## 🧠 Positioning

Visual Essay Engine is not an image generator.

It is a structural amplifier for AIGC creators.

In an age of infinite generation, structure becomes leverage.
---

## 🔎 Keywords

visual essay  
AIGC  
AI art  
bilingual captions  
Instagram grid  
narrative sequencing  
series packaging  
artist statement generator  
content structuring  
digital storytelling  

---

## 🚀 What It Generates

- Series title & subtitle
- Narrative architecture (essay-style progression)
- Bilingual compressed captions (EN first, CN second)
- Artist statement (EN/CN)
- 9-grid posting order
- Hashtag framework (core + domain + rotation + AIGC layer)

---

## 🧩 Core Method

Image  
→ Semantic Abstraction  
→ Narrative Architecture  
→ Compression  
→ Identity Framing  
→ Distribution Strategy  

---

## 📚 Narrative Modes

1. Signal → System → Conflict → Emergence  
2. Structure → Fracture → Reframe → Silence  
3. Brain → Market → Desire → Power → Crowd → Individual  

---

## 📦 Output

A complete “Series Package” ready for Instagram, X, or portfolio publishing.

---

## 🎯 Use Cases

- AI artists building long-form visual series  
- Creators structuring AIGC output  
- Founders shaping visual identity  
- Brand concept storytelling  
- Digital essay production  

---

Visual Essay Engine focuses on structure over aesthetics.  
In the age of infinite generation, structure is leverage.
---

## 🔧 Demo Invocation (Conceptual)

Input:
- 9 AIGC images
- Theme: urban systems & collective behavior
- Tone: analytical
- Platform: Instagram

Output:
- Structured narrative arc
- Bilingual minimal captions
- Artist statement
- 9-grid posting order
- Optimized hashtag framework