# Paper Notes Template

Use this template when writing notes on individual papers. Every expert reader should follow this structure.

---

## Template

```markdown
# {Paper Title}

**Short code:** {FirstAuthorLastName}{Year} (e.g., Chen2024)

## Metadata

| Field | Value |
|-------|-------|
| **Authors** | |
| **Year** | |
| **Venue** | |
| **DOI/Link** | |
| **Paper type** | [Empirical / Theoretical / Review / Methods / Position] |

---

## Core Argument

[1-2 paragraphs: What is the paper's central thesis or contribution? What problem does it solve?]

---

## Key Findings

[Bullet points. Each finding must include a section/page reference.]

- **Finding 1:** [Description] (§Section X, p.Y)
- **Finding 2:** [Description] (§Section X, p.Y)
- **Finding 3:** [Description] (§Section X, p.Y)

---

## Methods Summary

### Design
[What type of study? Experimental? Observational? Theoretical?]

### Data
[What data was used? Sample size? Source?]

### Analysis
[What analytical methods were applied?]

### Limitations
[What limitations do the authors acknowledge? What limitations are unacknowledged?]

---

## Notable Passages

[Include 2-5 direct quotes that capture key ideas. Each with section/page reference.]

### On [Topic 1]:
> "Direct quote from the paper."
> — §Section, p.X

**Why this matters:** [Brief explanation of significance]

### On [Topic 2]:
> "Direct quote from the paper."
> — §Section, p.X

**Why this matters:** [Brief explanation]

---

## Relevance to Research Question

**Research question:** {research_question}

[1-2 paragraphs: How does this paper address the research question? What does it contribute? What does it leave unanswered?]

### Supports:
- [What aspects of potential answers does this paper support?]

### Challenges:
- [What aspects does it challenge or complicate?]

### Gaps:
- [What relevant questions does it not address?]

---

## Connections to Other Papers

[Note connections to other papers in the reading group. This section may be brief if reading first, expanded after reading more papers.]

- **Related to {OtherPaper}:** [How do they connect?]
- **Contrasts with {OtherPaper}:** [Where do they differ?]

---

## Questions Raised

[Questions that arose while reading. These may inform the discussion phase.]

1. [Question about methodology, interpretation, or implications]
2. [Question about connections to other work]
3. [Question about future directions or applications]

---

## Reader's Assessment

**Strengths:**
- [What does this paper do well?]

**Weaknesses:**
- [What are its limitations?]

**Confidence in findings:** [High / Medium / Low] — [Brief justification]

**Importance for research question:** [High / Medium / Low] — [Brief justification]
```

---

## Usage Notes

### Citation Granularity

Every factual claim in notes must be traceable. Use these formats:

- **Section reference:** `(§Introduction)`, `(§Methods, subsection 2.3)`
- **Page reference:** `(p.5)`, `(pp.12-14)`
- **Combined:** `(§Results, p.8)`
- **Figure/Table:** `(Figure 3, p.10)`, `(Table 2)`

### Short Codes

The short code (e.g., `Chen2024`) is used for cross-referencing throughout the reading group:

- In discussion: "As noted in Chen2024..."
- In synthesis: `[Lin] (Chen2024, §Discussion)`
- In citations: `(Chen2024, §Methods, p.5)`

For multiple papers by same author in same year, use: `Chen2024a`, `Chen2024b`

### Paper Type Classification

| Type | Description |
|------|-------------|
| Empirical | Original data collection and analysis |
| Theoretical | Formal models, proofs, frameworks |
| Review | Systematic or narrative review of literature |
| Methods | New methodology, tool, or technique |
| Position | Argument or perspective piece |

### Adapting the Template

The template is designed to be comprehensive. For short papers or rapid reading:

**Minimum required sections:**
1. Metadata (title, authors, year, short code)
2. Core Argument (1 paragraph)
3. Key Findings (3-5 bullets with citations)
4. Relevance to Research Question (1 paragraph)
5. Questions Raised (2-3 questions)

**Full template for:**
- Central papers to the research question
- Papers that will be heavily discussed
- Papers with complex methodologies

### Quality Checklist

Before finalizing notes, verify:

- [ ] Short code is assigned
- [ ] Every finding has a section/page reference
- [ ] At least 2 direct quotes are included
- [ ] Research question relevance is explicitly addressed
- [ ] At least 2 questions are raised for discussion
- [ ] Reader's assessment is honest about limitations
