# Creator Video Feedback Framework

## The Core Problem

Underperforming creators spend too much time "selling" the product instead of demonstrating it visually.

**Key insight**: Ads reach non-followers who need to be hooked in 3 seconds.

## Quantitative Benchmarks

| Metric | GOOD (High ROI) | BAD (Low ROI) |
|--------|-----------------|---------------|
| Word Count | <100 words | >150 words |
| Time per Product | ~5 seconds | >15 seconds |
| Shows All Products Upfront | YES | NO |
| Format | Visual + Background Music | Talking/Explaining |

## Real Data Examples

| Type | Word Count | Pace | Result |
|------|------------|------|--------|
| HIGH ROI | 46 words | 5s/item | 15s for 3 outfits |
| HIGH ROI | 56 words | 5s/item | Quick visual showcase |
| HIGH ROI | 91 words | 5s/item | Shows product features |
| LOW ROI | 168 words | 30s/item | Too much explaining |
| EXCEPTION | 373 words | Detailed | Works - shows all first |

## High-Converting Video Patterns

1. **Time Allocation**
   - 15 seconds for 3 products = 5 seconds each
   - NOT 30 seconds explaining one product

2. **Opening Shot**
   - Show ALL products in first 2-3 seconds
   - Let viewers see the full haul immediately

3. **Show, Don't Tell**
   - Pure visual showcase + background music
   - Demonstrate features visually (stretch fabric, spin around)
   - Replace verbal explanations with visual demos

4. **Consistent Format**
   - Fixed background/setting
   - Repeatable script structure

## Low-Converting Video Problems

1. **Too Much Time "Selling"**
   - Extended verbal explanations
   - 30+ seconds per product
   - Word count >150

2. **Not Optimized for Non-Followers**
   - Assumes viewer knows creator's style
   - Long intros
   - Inside references

## The Exception: Kirstin Approach

Detailed verbal reviews CAN work when:
1. All products shown FIRST before any explanation
2. Low-pressure language: "if it doesn't fit, just return it"
3. Focus on genuine product introduction, not hard sell

## Coaching Feedback Templates

### For Slow Pacing
> "Your video spends ~30 seconds per product. High-performers show each item in ~5 seconds. Try: Quick cuts, one outfit = one scene transition."

### For Too Much Talking
> "Word count in your video: {X} words. Top performers: <100 words. Try: Replace explaining with VISUAL demonstration (stretch the fabric, spin around, etc.)"

### For No Overview
> "Show ALL products in the first 2 seconds. Let viewers see the full haul upfront. This sets expectation and keeps them watching."

### General Reminder
> "Remember: Ads reach people who DON'T follow you. They don't know your style. You have 3 seconds to grab attention - don't waste it on intros."

## Full Feedback Template

```
Hi [Creator],

Thanks for your video! Here's feedback to help boost performance:

**What's Working:**
- [Specific positive element]

**Opportunities to Improve:**

1. **Pacing**
   Current: ~{X} seconds per product
   Target: ~5 seconds per product
   Try: Quick cuts - one outfit = one scene transition

2. **Word Count**
   Current: {X} words
   Target: <100 words
   Try: Replace verbal descriptions with visual demos (stretch fabric, show fit)

3. **Opening**
   Recommendation: Show all products in first 2-3 seconds
   This lets viewers know what's coming and keeps them watching

**Key Reminder:**
Ads reach people who don't follow you yet. You have 3 seconds to grab a stranger's attention!

**Reference Videos (what "good" looks like):**
- instagram.com/reel/Cy1zs4gLGFG (15s, 3 outfits, pure visual)
- instagram.com/reel/DEybxPbNeOl (quick showcase, background music)

Best,
[Team]
```

## Reference Videos

### Good Examples (share with creators)
- `instagram.com/reel/Cy1zs4gLGFG` - 46 words, 15s/3 outfits
- `instagram.com/reel/DEybxPbNeOl` - 56 words, quick showcase
- `instagram.com/reel/DHHr5o2s1LG` - 91 words, fast cuts
- `instagram.com/reel/DBd6NxbOeBb` - 91 words, visual demo

### Exception (detailed review done right)
- `instagram.com/reel/DCQJ355RWSE` - 373 words, shows all first

### Bad Example (what to avoid)
- `instagram.com/reel/DRCdjLlDcla` - 168 words, 30s/outfit
