---
name: Violin
description: Violin practice strategies, technique correction, intonation development, and progress tracking.
metadata:
  category: music
  skills: ["violin", "strings", "practice", "music", "instrument"]
---

## Core Behavior

- Create `~/violin/` as workspace on first interaction
- After practice, offer to log progress; see `progress.md`

## Before Advising

- Ask level — years playing, current repertoire
- Ask goals — classical vs fiddle vs orchestral differ
- Ask teacher status — self-taught needs different guidance

## Practice Errors

- Practicing mistakes — slow until correct, then speed up
- Ignoring intonation — check against open strings or drone
- Too much repertoire, not enough scales — gaps show in pieces
- Marathon sessions — 30 min focused beats 2 hours

## Left Hand Traps

- Squeezing neck — thumb light, arm weight does work
- Flat fingers — curve for clean stopping
- Ignoring hand frame — 1-4 spacing set, don't reach
- Shifting tension — release before shift, land light

## Bow Arm Traps

- Pressing into string — arm weight not muscle
- Stiff wrist — wrist leads at frog, flexible throughout
- Ignoring contact point — wandering = wavering tone
- Bow not parallel — watch in mirror

## Mistakes by Level

**Beginners:** Death grip, no vibrato concept, scratchy tone

**Intermediate:** Shifting anxiety, position isolation, vibrato tense

**Advanced:** Expressive ruts, neglecting études, avoiding positions

## Intonation Work

| Method | When |
|--------|------|
| Drone practice | Daily scales against tonic |
| Double-stop checks | 4ths, 5ths, octaves expose errors |
| Slow scales | Listen to each interval |

## Tone Production

- Speed + weight + contact point = tone color
- Slow near bridge = intense; fast near fingerboard = soft
- Pressure chokes sound — let string vibrate

## Troubleshooting

- "Scratchy tone" → check bow speed vs pressure
- "Shifting out of tune" → release, shift, THEN place
- "Vibrato tense" → arm vibrato first
- "4th finger weak" → exercises, don't avoid

## Setup

Old strings = dull tone — change every 3-6 months; rehair bow when slippery

## Progress Tracking

Log to `~/violin/`: repertoire, scales by key, shifting exercises

## What to Surface

- "G major clean? Ready for A-flat?" / "No shifting logs — want études?"
