---
name: Vietnamese
description: Write Vietnamese that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Vietnamese is technically correct but sounds off. Too formal. Too textbook. Natives write more casually, with appropriate pronouns and particles. Match that.

## Formality Default

Default register is too high. Casual Vietnamese is warm. Unless explicitly formal: lean casual and choose pronouns based on relationship.

## Pronouns Are Critical

Vietnamese pronouns define the relationship:
- Tôi: formal/neutral I
- Mình/Tớ: casual I (friendly)
- Anh/Chị/Em: based on relative age
- Bạn: peer, friend
- Wrong pronouns = wrong relationship = unnatural

## Age-Based Address

Vietnamese respects age hierarchy:
- Anh (older male), Chị (older female)
- Em (younger person)
- Cô/Chú/Bác: older adults, relatives
- Online peers often use bạn or mình

## Particles & Softeners

These make Vietnamese natural:
- À/Ạ: politeness, acknowledgment
- Nhé: softening requests
- Nha: casual "okay?"
- Nhỉ: seeking agreement
- Đi: urging action

## Fillers & Flow

Real Vietnamese has fillers:
- À, ừ, ờ
- Thì, là, mà
- Kiểu, đại loại
- Nói chung, thật ra

## Casual Patterns

Spoken patterns in writing:
- Không → Hông/Ko
- Biết → Bít
- Được → Đc
- Common in texting

## Expressiveness

Don't pick the safe word:
- Tốt → Tuyệt, Quá đỉnh, Xịn
- Xấu → Tệ, Dở, Chán
- Rất → Siêu, Cực, Quá

## Common Expressions

Natural expressions:
- OK, Được rồi, Ừ
- Không sao, Kệ đi
- Thật hả?, Vậy hả?
- Đúng rồi, Chuẩn

## Reactions

React naturally:
- Thật á?, Hả?, Sao?
- Ôi!, Trời ơi!, Chời!
- Hay quá!, Đỉnh!, Xịn!
- Haha, =))), hihi

## Regional Differences

North vs South:
- North: Vâng (yes formal), mình
- South: Dạ (yes formal), tui instead of tôi
- Different vocabulary for some words
- Stay consistent to one region

## Tones in Text

Tones matter—spelling must be exact:
- Ma (ghost) vs Mà (but) vs Má (mother)
- Dấu marks are essential
- Missing marks = confusing or wrong

## The "Native Test"

Before sending: would a Vietnamese screenshot this as "AI-generated"? If yes—wrong pronouns, too formal, no particles. Fix relationships first.
