# Vienna Visitor Tips

## Essential First-Timer Tips

### Money
- **Currency:** Euro (€)
- **Cards:** Widely accepted, but carry some cash
- **Cash needed:** Stephansdom tickets, some markets, small shops
- **Tipping:** 5-10% at restaurants, round up at cafés, €1-2 for coat check
- **ATMs:** Use bank ATMs, avoid Euronet (high fees)

### Language
- **Official:** German (Austrian variant)
- **English:** Widely spoken in tourist areas, hotels, young people
- **Useful phrases:**
  - Grüß Gott = Hello (formal)
  - Servus = Hello/Goodbye (informal)
  - Danke = Thank you
  - Bitte = Please/You're welcome
  - Zahlen, bitte = Bill, please

### Water
- **Tap water:** Excellent — alpine spring water
- **Free fountains:** Throughout city
- **Bring:** Refillable bottle

### Opening Hours
- **Shops:** Mon-Fri 9am-6pm, Sat until 5pm
- **Sunday:** Almost everything closed (except restaurants, cafés)
- **Museums:** Often closed Mondays
- **Restaurants:** Lunch 11:30am-2pm, dinner from 6pm

---

## Transport Tips

### Getting Around

| Pass | Price | Worth It? |
|------|-------|-----------|
| Single ticket | €2.40 | For 1-3 rides/day |
| 24h pass | €8 | 4+ rides |
| 48h pass | €14.10 | Best for 2-day visits |
| 72h pass | €17.10 | Best for 3-day visits |
| Weekly pass | €17.10 | Mon-Sun only |

**Buy tickets:** Machines at stations, Wiener Linien app, tobacco shops

### Metro (U-Bahn) Tips
- Runs 5am-midnight (24h on Fri/Sat nights)
- No turnstiles but random checks — €115 fine
- Lines: U1-U6 (U5 under construction)
- Very clean and safe

### Tram Tips
- Scenic way to see the city
- **Tram 1 or 2:** Circles the Ring — great free sightseeing
- Buy ticket before boarding

### Airport Transport
- **Best value:** S7 train, €4.40, 25 min
- **Skip:** CAT (€14.90) — only 9 min faster
- **Night:** Night bus or taxi (~€35 fixed rate)

### Walking
- **Innere Stadt:** Everything walkable
- **Google Maps:** Works well for walking routes
- **Watch for:** Bikes on shared paths

---

## Money-Saving Secrets

### Free Attractions
- Wien Museum Karlsplatz (permanent exhibition)
- All gardens (Belvedere, Schönbrunn, Burggarten)
- Churches (Stephansdom nave, Jesuitenkirche, Votivkirche)
- MuseumsQuartier courtyards
- Ringstrasse architecture walk

### Free Days
- **First Sunday:** Wien Museum locations
- **First Thursday 6-9pm:** Leopold Museum
- **Under 19:** Free at most museums

### Cheap Eats
- **Würstelstand:** Iconic sausage stands, €3-5
- **Bäckerei:** Bakeries with sandwiches, €2-4
- **Billa/Spar:** Supermarket meals
- **Naschmarkt stalls:** Not restaurants (60% cheaper)
- **University Mensas:** Open to public, €5-8

### Cheap Entertainment
- **Opera standing room:** €13-18 for world-class
- **Musikverein standing:** From €6
- **Film Festival (July-Aug):** Free outdoor cinema at Rathaus
- **Donauinselfest (June):** Europe's largest free festival

### Transport Savings
- S7 to airport (not CAT)
- 72h pass for 3+ day visits
- Walk the center — it's compact

---

## Etiquette

### Restaurant
- Wait to be seated at restaurants
- Say "Grüß Gott" when entering smaller places
- "Mahlzeit" = enjoy your meal (also used as greeting at lunchtime)
- Don't split bills into tiny amounts — Austrians think it's cheap
- Tip 5-10%, round up for small bills

### Coffeehouse
- Staying hours is expected and welcome
- Order by proper name (Melange, not "cappuccino")
- Waiter brings water automatically (free)
- It's not rude if waiter seems aloof — it's tradition
- Bill comes when you ask ("Zahlen, bitte")

### Public Transport
- Give up seats for elderly, pregnant women
- Don't eat smelly food
- Queue properly at bus/tram doors
- Have ticket before boarding (inspectors are strict)

### General
- **Quiet hours:** 10pm-6am, noon-3pm (some buildings)
- **Recycling:** Take it seriously
- **Jaywalking:** Locals wait for green lights
- **Titles:** Use Herr/Frau + academic titles if known
- **Smoking:** Banned indoors, common on terraces

---

## Seasonal Tips

### Summer (Jun-Aug)
- Hot (25-35°C), bring sunscreen
- AC not standard everywhere
- Many locals on vacation (August especially)
- Outdoor pools open (Gänsehäufel, Schönbrunn)
- Film Festival at Rathaus (free)

### Winter (Nov-Feb)
- Cold (-5 to 5°C), bring layers
- Christmas markets (late Nov-Dec 23)
- Ball season (January-February)
- Some Heurigen closed
- Shorter museum hours sometimes

### Spring/Fall
- Best weather for walking
- Wine harvest (September)
- Gardens at their best (May)
- Fewer crowds than summer

---

## Common Mistakes

1. **Not booking Schönbrunn ahead** — Fixed time slots, popular
2. **Eating at Stephansplatz** — Tourist trap prices
3. **Skipping opera standing room** — Best deal in town
4. **No cash for Stephansdom** — Ticket office cash only
5. **Underestimating distances** — Vienna is bigger than it looks
6. **Sunday shopping plans** — Everything closed
7. **Ignoring free museum days** — Missing easy savings
8. **Taking CAT train** — S7 is 60% cheaper
9. **Missing Heurigen** — Unique Vienna experience
10. **Overtipping** — 5-10% is plenty, Austrians don't overtip

---

## Photography Spots

### Classic Shots
- **Stephansdom** — From Graben or rooftop bars
- **Gloriette at Schönbrunn** — Palace + city panorama
- **Belvedere Gardens** — Palace reflected in fountains
- **Ringstrasse** — Parliament, City Hall at night

### Hidden Gems
- **Michaelerplatz** — Hofburg facade
- **Spittelberg streets** — Cobblestones + baroque
- **Danube Canal** — Street art murals
- **Kahlenberg** — City panorama at sunset

### Best Times
- **Golden hour:** 6-8am (summer), 7-9am (winter) — empty streets
- **Blue hour:** Just after sunset — lights on, sky still blue
- **Night:** Ringstrasse buildings lit up

---

## Tech & Connectivity

### WiFi
- Free in most cafés, hotels
- Vienna Free WiFi in public spaces (limited)
- Quality varies — bring mobile data backup

### Apps
- **Wiener Linien:** Official transport app
- **Qando:** Real-time transit
- **Google Maps:** Good for Vienna
- **Wien Mobil:** Bike share, scooters

### Charging
- EU plugs (Type C/F)
- USB charging in newer U-Bahn cars
- Cafés usually have outlets

### Emergency
- **112:** Pan-European emergency
- **133:** Police
- **144:** Ambulance
- **122:** Fire

---

## Day Trip Suggestions

### Easy Half-Day
- **Kahlenberg viewpoint** — 30 min by bus, vineyards + views
- **Klosterneuburg Monastery** — 20 min S-Bahn

### Full Day
- **Wachau Valley** — Wine country, boat + train
- **Bratislava** — 1 hour, different country
- **Baden bei Wien** — Spa town, 30 min

### Multi-Day
- **Salzburg** — 2.5 hours, Mozart + Sound of Music
- **Budapest** — 2.5 hours, stunning city
- **Prague** — 4 hours, fairy tale old town

---

## Packing List

### Year-Round
- Comfortable walking shoes
- Layers (weather changes)
- Refillable water bottle
- Power adapter (EU)
- Small cash amount

### Summer Additions
- Sunscreen, hat
- Swimsuit (pools, Danube Island)
- Light clothes

### Winter Additions
- Warm coat, scarf, gloves
- Waterproof shoes
- Thermals for outdoor markets

*Updated February 2026*
