# Vienna Visitor Attractions Guide

## 🏛️ Must-See Attractions

### Schönbrunn Palace
**Vienna's Versailles — Habsburg summer residence**

| Ticket Type | Adult | Child (6-18) | Student |
|-------------|-------|--------------|---------|
| Palace Ticket (40 rooms) | €38 | €28 | €31.50 |
| State Apartments (shorter) | €28 | €19 | €23 |
| **Sisi Pass** (3 locations) | €57 | €37 | — |

- **Gardens:** FREE and magnificent
- **Booking:** imperialtickets.com — fixed time slots required
- **Best time:** 9am weekdays, avoid summer weekends

### St. Stephen's Cathedral (Stephansdom)
**Gothic masterpiece in Vienna's heart**

| Area | Price | Notes |
|------|-------|-------|
| Main nave (free area) | FREE | Limited view |
| South Tower climb (343 steps) | €6 | Best city views |
| Catacombs tour | €6.50 | 30-min guided |
| **All-inclusive** | €20-25 | Best value |

⚠️ On-site tickets are **CASH ONLY**

### Belvedere Palace & Museum
**Klimt's "The Kiss" and world's largest Klimt collection**

| Ticket | Online | On-site |
|--------|--------|---------|
| Adults | €19.50 | €21 |
| Under 26 / 65+ | €15.50 | €17.50 |
| Under 19 | FREE | FREE |

- **Gardens:** FREE — stunning baroque gardens
- **Hours:** Daily 9am-6pm

### Hofburg Palace (Sisi Museum)
**Habsburg winter residence**

| Ticket | Adult | Child |
|--------|-------|-------|
| Sisi Museum + Imperial Apartments | €20 | €12 |
| **Sisi Pass** (incl. Schönbrunn) | €57 | €37 |

Free: Courtyards exploration

### Kunsthistorisches Museum
**Vienna's "Louvre" — world-class art collection**

| Ticket | Price |
|--------|-------|
| Adults | €22-24 |
| Under 19 | FREE |

- **Highlights:** World's largest Bruegel collection, Vermeer, Raphael
- **Best time:** Thursday evenings until 9pm

---

## 🎭 Music & Opera

### Vienna State Opera
**World's premier opera house**

| Type | Price |
|------|-------|
| Regular seats | €15-€250+ |
| U27 tickets (under 27) | €20 |
| **Standing room** | €13-18 |

**Standing room tips:**
- Day-of from 10am online and box office
- Parterre standing = best views
- Get free BundestheaterCard for major discounts

### Musikverein (Golden Hall)
**Home of Vienna Philharmonic**

- Concerts: €35-€200+
- Standing: from €6
- Tours: ~€9
- U30 program for under-30s

---

## 🖼️ Major Museums

### Leopold Museum (MuseumsQuartier)
**World's largest Schiele collection**

| Ticket | Price |
|--------|-------|
| Adults | €19 |
| Under 26 | €16 |
| Under 7 | FREE |

**Free:** First Thursday 6-9pm

### Albertina Museum
**World-class print collection, Monet to Picasso**

- Adults: ~€18.90
- Under 19: FREE
- Hours: Wed & Fri until 9pm

### Natural History Museum
Venus of Willendorf, dinosaurs, gems
- Adults: ~€16
- Under 19: FREE

---

## 💰 Free Attractions

### Always Free
- **Wien Museum Karlsplatz** — Vienna history, free permanent exhibition
- **Belvedere Gardens** — Baroque gardens with city views
- **Schönbrunn Gardens** — Massive imperial gardens
- **Ringstrasse Walk** — Circle past opera, parliament, city hall
- **Naschmarkt** — Browse Vienna's famous market
- **Danube Canal Street Art** — Ever-changing murals
- **Churches** — Jesuit Church, Votivkirche

### Free First Sunday of Month
- All Wien Museum locations
- Military History Museum
- Composer apartments (Beethoven, Mozart, Schubert)

### Free First Thursday 6-9pm
- Leopold Museum (normally €19)

---

## ⚠️ Tourist Traps

| Place | Issue | Alternative |
|-------|-------|-------------|
| **Figlmüller** | Long queues, very touristy | Schnitzelwirt, Gasthaus Pöschl |
| **Hotel Sacher** | €9+ for cake slice | Demel, Café Central |
| **Stephansplatz restaurants** | Overpriced | Walk 2 blocks away |
| **Mozart Concert** hawkers | Overpriced tickets | Book directly at venues |
| **Fiaker** (carriages) | €80-110, crowds, fumes | Tram 1/2 circles Ring for €2.40 |

---

## 💎 Hidden Gems

### Spittelberg (7th district)
Cobblestone streets behind MuseumsQuartier, secret garden restaurants, no tour groups

### Wine Villages in Vienna
- **Wieninger am Nussberg** — Vineyards with city views
- **Mayer am Nussberg** — Traditional Heuriger

### Schottenkirche Vespers
Benedictine monks sing Latin prayers at twilight — free, extraordinary

### Virgilkapelle
13th-century chapel under Stephansplatz metro — free first Sunday

---

## 🎫 Passes Worth Considering

| Pass | Price | Best For |
|------|-------|----------|
| **Vienna Pass** | from €87/day | 3+ attractions daily |
| **Vienna City Card** | from €17/24h | Transit + discounts |
| **Sisi Pass** | €57 | Schönbrunn + Hofburg + Furniture |
| **Wien Museum Annual** | €29 | History buffs |

---

## 📌 Booking Summary

| Book in Advance | Day-Of OK |
|----------------|-----------|
| Schönbrunn (time slots) | Belvedere |
| Opera (popular shows) | Kunsthistorisches |
| Musikverein concerts | Leopold Museum |

**Official sites:** imperialtickets.com, belvedere.at, wiener-staatsoper.at

*Prices verified February 2026*
