# Vienna Transport

## Overview

Vienna has one of the world's best public transport systems. Clean, punctual, extensive, and affordable.

**Operator:** Wiener Linien

---

## Tickets & Passes

### Single & Short-Term

| Ticket | Price | Valid |
|--------|-------|-------|
| Single ticket | €2.40 | 1 journey (transfers OK) |
| 24-hour pass | €8.00 | 24h from validation |
| 48-hour pass | €14.10 | 48h from validation |
| 72-hour pass | €17.10 | 72h from validation |
| Weekly pass | €17.10 | Mon 00:00 - next Mon 09:00 |

### Long-Term

| Pass | Price | Notes |
|------|-------|-------|
| Monthly pass | €51 | Calendar month |
| Annual pass | €365 | Best deal (€1/day) |
| Semester ticket | €75 | Students only |
| Youth pass (U26) | €19.60/month | Under 26 |

### Where to Buy
- **Machines:** All U-Bahn stations
- **App:** Wiener Linien app (recommended)
- **Tobacco shops (Trafik)**
- **Online:** wienerlinien.at

### Validation
- **Tickets must be validated** before first use
- Stamp in blue machines at platform entrances
- Passes: Validate once on first use
- **No turnstiles** — honor system with random checks
- **Fine:** €115 if caught without valid ticket

---

## U-Bahn (Metro)

### Lines

| Line | Color | Route Highlights |
|------|-------|------------------|
| U1 | Red | Stephansplatz, Praterstern, Kagran |
| U2 | Purple | Schottentor, Rathaus, Stadion |
| U3 | Orange | Westbahnhof, Stephansplatz, Simmering |
| U4 | Green | Schönbrunn, Karlsplatz, Heiligenstadt |
| U6 | Brown | Floridsdorf to Siebenhirten |
| U5 | Turquoise | Under construction |

### Hours
- **Regular:** ~5:00am to ~12:30am
- **Friday/Saturday nights:** 24-hour service (all lines)
- **Frequency:** Every 2-5 min (peak), 5-10 min (off-peak)

### Tips
- Stephansplatz is central hub (U1/U3)
- Karlsplatz (U1/U2/U4) major interchange
- Apps show real-time departures

---

## Trams (Straßenbahn)

Vienna has one of the world's largest tram networks — **28 lines**.

### Key Lines

| Line | Route |
|------|-------|
| **1** | Ringstraße (clockwise) |
| **2** | Ringstraße (counterclockwise) |
| **D** | Südbahnhof to Nussdorf |
| **38** | Schottentor to Grinzing |
| **49** | Ring to Hütteldorf |

### Tram Tips
- Great for sightseeing (ride lines 1/2 around Ring)
- Older trams have character
- Buy ticket before boarding (validators inside)
- Ring your stop (button)

---

## Buses

### Types
- **City buses:** Fill gaps in U-Bahn/tram network
- **Night buses:** N1-N9, when U-Bahn closed (except Fri/Sat)
- **Regional buses:** To suburbs and beyond

### Night Bus
- Runs 00:30-5:00am (Sun-Thu)
- Departs from Schwedenplatz, other hubs
- Same tickets as regular transport

---

## S-Bahn (Regional Rail)

### Uses
- Airport (S7 — best value)
- Suburbs (21st, 22nd, 23rd districts)
- Day trips (Baden, Krems, Mödling)

### Airport Connection

| Option | Price | Time |
|--------|-------|------|
| S7 train | €4.40 | 25 min |
| CAT (City Airport Train) | €14.90 | 16 min |
| Bus | ~€8 | 20-30 min |
| Taxi | €35-45 | 20-40 min |

**Recommendation:** Take S7 — almost as fast as CAT at 1/3 the price.

---

## Cycling

### City Bikes (WienMobil Rad)
- **First 30 min:** Free (then €0.60/30 min)
- **Registration:** €1 (annual)
- **Stations:** Throughout center
- **App:** WienMobil

### Infrastructure
- Extensive bike lane network
- Danube Canal path popular
- Donauinsel (21km car-free)
- Vienna Woods trails

### Rules
- Bike lanes mandatory where present
- Lights required at night
- Helmet recommended (not required for adults)
- Lock always (theft occurs)

---

## Taxis & Ride-Sharing

### Taxis
- **Apps:** Taxi 40100, Taxi 31300, Bolt
- **Street hail:** Available (yellow/blue signs)
- **Airport fixed rate:** ~€35-45

### Ride-Sharing
- **Uber:** Available, but uses licensed taxis (same price)
- **Bolt:** Available, slightly cheaper
- No UberX-style service (regulated)

### Typical Costs
- Flagfall: ~€4
- Per km: ~€1.50
- Airport: €35-45 fixed

---

## Driving

### Parking
- **Kurzparkzonen:** Short-term parking zones (most of center)
- **Tickets:** Buy at machines or via app (Handyparken)
- **Cost:** €2-4/hour depending on zone
- **Max duration:** Usually 2-3 hours
- **Garage parking:** €3-5/hour

### Car Sharing
- **ShareNow (Car2Go):** Available
- **ELOOP:** Electric cars
- Apps show available cars

### Recommendation
**Don't drive in Vienna** unless necessary. Public transport is:
- Faster (no parking search)
- Cheaper (no parking fees)
- Less stressful

---

## Apps

### Essential

| App | Use |
|-----|-----|
| **Wiener Linien** | Official transit app, tickets |
| **Wien Mobil** | Multi-modal (transit, bikes, scooters) |
| **Qando Wien** | Real-time departures |
| **Google Maps** | Directions (uses Wiener Linien data) |
| **ÖBB** | Regional/national trains |

---

## Accessibility

Vienna's transport is very accessible:
- All U-Bahn stations have elevators
- Low-floor trams and buses
- Audio announcements
- Tactile guidance systems
- Wheelchair spaces on all vehicles

---

## Day Trip Transport

### Popular Destinations

| Destination | Transport | Time | Price (approx) |
|-------------|-----------|------|----------------|
| **Schönbrunn** | U4 | 15 min | €2.40 |
| **Grinzing** | Tram 38 | 25 min | €2.40 |
| **Bratislava** | Train | 1h | €15-20 |
| **Baden bei Wien** | Badner Bahn | 30 min | €5 |
| **Krems (Wachau)** | Train | 1h | €20 |
| **Melk** | Train | 1h | €25 |
| **Salzburg** | Train | 2.5h | €30-50 |

### ÖBB (Austrian Rail)
- Book at oebb.at
- **Sparschiene:** Cheap advance tickets
- **Vorteilscard:** Discount card for frequent travelers (€66/year, 50% off)

---

## Quick Reference

| Need | Solution |
|------|----------|
| To center from airport | S7 (€4.40, 25 min) |
| Tourist sightseeing | Tram 1/2 around Ring |
| Schönbrunn | U4 to Schönbrunn |
| Prater | U1 or U2 to Praterstern |
| Heurigen (Grinzing) | Tram 38 from Schottentor |
| Donauinsel | U1 to Donauinsel |
| Late night (Sun-Thu) | Night bus from Schwedenplatz |
