# Vienna: Student Guide

## Universities

### Major Public Universities

| University | Students | Focus | QS Ranking |
|------------|----------|-------|------------|
| **University of Vienna** | ~91,000 | Comprehensive | ~150 |
| **TU Wien** | ~30,000 | Engineering, Tech | ~200 |
| **WU Wien** | ~23,000 | Business | Top 50 (Business) |
| **BOKU** | ~12,000 | Life Sciences | ~250 |
| **Medical University Vienna** | ~8,000 | Medicine | Top 100 (Medicine) |
| **MDW** | ~3,000 | Music, Arts | World's largest |

### Private Universities

| University | Focus | Tuition/Year |
|------------|-------|--------------|
| CEU | Social Sciences | €8,000-15,000 |
| MODUL | Tourism, Business | €12,000-21,000 |
| Webster Vienna | International Business | €24,000+ |

### Universities of Applied Sciences
- FH Technikum Wien (Tech)
- FH Campus Wien (Health, Social Work)
- FH Wien der WKW (Business)

---

## Admission

### Requirements

**EU/EEA Students:**
- Secondary school diploma (equivalent to Matura)
- Meet program-specific requirements
- German B2 usually required

**Non-EU Students:**
- Same + earlier application deadlines
- Visa required

### Language Requirements

| Language | Level | Proof |
|----------|-------|-------|
| German | B2 (usually) | ÖSD, Goethe, TestDaF |
| English | IELTS 6.5+ / TOEFL 90+ | For English programs |

### Restricted Programs
These require entrance exams:
- Medicine (MedAT)
- Psychology
- Veterinary Medicine
- Some Communications/Media
- Architecture (at some universities)

### Deadlines

| Semester | EU | Non-EU |
|----------|-----|--------|
| Winter | Sept 5 | Earlier (check university) |
| Summer | Feb 5 | Earlier (check university) |

---

## Costs & Budget

### Tuition

| Student Type | Per Semester |
|--------------|--------------|
| EU/EEA | ~€21 (ÖH fee only) |
| Non-EU | ~€750 |

Vienna's public universities are essentially free for EU students.

### Living Costs

| Item | Monthly |
|------|---------|
| Room (shared) | €350-500 |
| Room (dorm) | €300-450 |
| Studio | €600-900 |
| Food | €200-300 |
| Transport (semester) | €75/6 months |
| Phone | €10-20 |
| Entertainment | €50-150 |
| **Total** | **€700-1,200** |

### Proof of Funds
Non-EU students must show ~€12,000/year in savings or income.

---

## Student Housing

### Options

| Type | Cost | Pros | Cons |
|------|------|------|------|
| **Studentenheim (Dorm)** | €300-450 | Cheap, social, easy | Waiting lists, rules |
| **WG (Shared flat)** | €350-550 | Freedom, social | Finding one is hard |
| **Private studio** | €600-900 | Privacy | Expensive |

### Student Residences
- **OeAD Housing:** oead.at — International students
- **Wihast:** wihast.at — Multiple locations
- **Home4Students:** home4students.at
- **STUWO:** stuwo.at

### Finding WG (Shared Flat)
- **WG-gesucht.de** — Main platform
- **Facebook groups** — "WG Wien", student groups
- **willhaben.at** — General listings
- **University notice boards**

### Tips
- Apply for dorms early (3-6 months ahead)
- WG competition fierce — present well
- University first-year housing programs exist
- Semester start = hardest time to find

---

## Student Life

### ÖH (Student Union)
- Mandatory membership (~€21/semester)
- Legal help
- Discounts
- Representation

### Student Discounts

| What | Discount |
|------|----------|
| **Transport** | Semester ticket: €75/6 months |
| **Museums** | Free or reduced (under 19/26) |
| **Opera standing** | €10-18 |
| **Cinema** | Student nights ~€7 |
| **Restaurants** | Mensas €4-8 |
| **Software** | Microsoft, Adobe etc. free/cheap |

### Mensas (Cafeterias)
All universities have subsidized canteens:
- Meals: €4-8
- Open to all students
- Quality varies by location
- Best value food in Vienna

---

## Working While Studying

### EU Students
- Can work unlimited hours
- Same rights as Austrian workers

### Non-EU Students
- 20h/week during semester
- Full-time during breaks
- Need work permit (usually automatic with residence permit)

### Student Jobs

| Type | Pay/Hour |
|------|----------|
| Retail | €10-13 |
| Hospitality | €10-15 |
| Tutoring | €15-25 |
| Tech (part-time) | €15-30 |
| Office/Admin | €12-18 |

### Where to Find
- University job boards
- karriere.at
- Studentjob.at
- Facebook groups
- Networking

---

## Learning German

### At University
- Vorkurs (preparatory German courses)
- Sprachenzentrum (language center)
- Often subsidized or free

### External Options
- **VHS (Volkshochschule):** Affordable adult education
- **ÖIF:** For visa requirements
- **Goethe Institut:** Premium, certified
- **Tandem partners:** Free language exchange

### Reality
- Many English-taught programs
- German essential for daily life
- B2 minimum for comfort

---

## Districts for Students

### Best Areas

| District | Why | Rent |
|----------|-----|------|
| **9th (Alsergrund)** | Near University of Vienna | €€€ |
| **2nd (Leopoldstadt)** | Near WU, lively | €€ |
| **5th (Margareten)** | Affordable, central | € |
| **4th (Wieden)** | Near TU, Naschmarkt | €€ |
| **10th (Favoriten)** | Cheapest, decent transit | € |

### Transit
With semester ticket, all of Vienna is accessible.

---

## Health Insurance

### Requirements
All students need health insurance:

**EU Students:**
- EHIC (European Health Insurance Card)
- May need supplemental insurance

**Non-EU Students:**
- Must arrange insurance
- Options: Student insurance (~€60/month), private insurance

### ÖGK Student Insurance
- Available for working students
- Through employment

---

## Visa (Non-EU)

### Student Residence Permit

**Requirements:**
- University admission
- Proof of funds (~€12,000/year)
- Health insurance
- Accommodation proof
- No criminal record

**Process:**
1. Apply at Austrian embassy (before arrival)
2. Or MA 35 if legally in Austria
3. Wait 2-4 months
4. Collect biometric card

**Renewal:** Annual, requires proof of progress

---

## Academic Culture

### Expectations
- Self-directed learning
- Less hand-holding than US/UK
- Lecture attendance not always mandatory
- Exams often once per semester
- Academic freedom (choose pace)

### Tips
- Attend Orientierungswoche (orientation)
- Join study groups (Lerngruppen)
- Use ÖH services
- Professors less accessible — use office hours
- Tutors (Tutorien) very helpful

---

## Nightlife & Social

### Student Bars
- **Flex:** Danube Canal, electronic
- **Camera Club:** Alternative
- **U4:** Student party institution
- **Das Werk:** Industrial vibes
- **Pratersauna:** Summer hotspot

### Student Events
- Semester opening parties
- Faculty parties (Fachschaftsfeste)
- Pub crawls
- University ball (Uniball)

### Cheap Entertainment
- Heuriger evenings (wine + food)
- Donauinsel (free recreation)
- Free museum days
- MuseumsQuartier hangout (free)
- Prater (Ferris wheel, park)

---

## Resources

- **OeAD:** oead.at — International students
- **ÖH:** oeh.ac.at — Student union
- **Studieren.at:** Study in Austria portal
- **University websites:** Detailed program info
- **Facebook groups:** "International Students Vienna"

---

## Quick Checklist

### Before Arriving
- [ ] University admission
- [ ] Visa (non-EU)
- [ ] Housing application
- [ ] Health insurance
- [ ] Proof of funds

### First Weeks
- [ ] Meldezettel (register address)
- [ ] Bank account
- [ ] SIM card
- [ ] University enrollment
- [ ] ÖH membership
- [ ] Semester ticket
- [ ] Student ID (Studentenausweis)
