# Vienna: Startup Guide

## Ecosystem Overview

Vienna is Central Europe's startup hub, valued at ~$12 billion with strong government support and growing VC activity.

### Key Stats (2026)
- **1,800+ startups** in Vienna
- **57%** of Austria's startups
- **20%** annual growth rate
- **3 unicorns:** Bitpanda, GoStudent, Tricentis
- **$2.66B** total funding raised
- **60%+** startups have international employees

---

## Why Vienna?

### Advantages
- Central European location (access to DACH + CEE)
- Strong talent pool (universities, immigration)
- Lower costs than Western Europe
- High quality of life (retention)
- Government support & grants
- Growing VC ecosystem

### Challenges
- Smaller market than Berlin/London
- More conservative investor culture
- German language in B2B
- Bureaucracy can be slow
- Limited later-stage funding locally

---

## Hot Sectors

### Strongest
- **FinTech:** Bitpanda, N26 operations, strong banking heritage
- **EdTech:** GoStudent, education focus
- **HealthTech/Life Sciences:** Medical university ecosystem
- **Climate/Sustainability:** Growing focus, government priority

### Emerging
- **Quantum Computing:** University of Vienna research
- **AI/ML:** Growing scene
- **PropTech/Construction:** PlanRadar success
- **Cybersecurity:** Enterprise demand

---

## Funding Landscape

### Stages

| Stage | Typical Amount | Common Sources |
|-------|----------------|----------------|
| Pre-seed | €50K-200K | Angels, FFG grants |
| Seed | €200K-1M | Austrian VCs, Angels |
| Series A | €2M-8M | VCs, international |
| Series B+ | €10M+ | International VCs |

### Local VCs

| VC | Focus | Check Size |
|----|-------|------------|
| Speedinvest | Seed-Series A | €200K-3M |
| 3VC | Seed-Series A | €500K-5M |
| eQventure | Tech | €100K-500K |
| Calm/Storm | Consumer | Seed |
| Push Ventures | Multiple | Seed |

### International Active in Vienna
- Sequoia (scouts)
- Index Ventures
- Project A
- HV Capital
- Cherry Ventures

### Government Funding

| Program | What | Amount |
|---------|------|--------|
| **FFG** | Research grants | Up to €3M |
| **AWS** | Loans, guarantees | Varies |
| **Vienna Business Agency** | Grants, support | Up to €100K |
| **Jungunternehmerförderung** | Young entrepreneur support | Up to €5K |

---

## Starting a Company

### Legal Forms

| Type | Description | Min Capital |
|------|-------------|-------------|
| **GmbH** | LLC equivalent | €10K (€5K to start) |
| **UG** | Not available in Austria | - |
| **Einzelunternehmen** | Sole proprietor | None |
| **OG/KG** | Partnerships | None |

**GmbH is standard** for startups seeking investment.

### Registration Process

1. **Notary:** Draft articles of association (Gesellschaftsvertrag)
2. **Bank:** Open company account, deposit capital
3. **Commercial Register:** Register at Firmenbuch
4. **Tax Office:** Get tax numbers
5. **Social Security:** Register as employer (if applicable)

**Timeline:** 2-4 weeks
**Cost:** €1,500-3,000 (notary, registration, fees)

### Simplified Path
- **Gründerservice WKO:** Free support
- **Vienna Business Agency:** Free consulting
- Some notaries offer startup packages

---

## Support Organizations

### Accelerators & Incubators

| Program | Focus | Notes |
|---------|-------|-------|
| **Austrian Startups** | Ecosystem hub | Community, events |
| **Inits** | TU Wien + BOKU | University spinouts |
| **I.E.C.T.** | Tech transfer | Hermann Hauser backed |
| **Vienna Business Agency** | General | Grants, support |
| **INiTS** | University spinouts | Pre-seed, mentoring |
| **Impact Hub Vienna** | Social impact | Co-working + programs |

### Corporate Programs
- **weXelerate:** Corporate-startup collaboration
- **Raiffeisen Elevator Lab:** FinTech
- **A1 Startup Campus:** Telecom/Tech

---

## Hiring

### Finding Talent

| Source | Best For |
|--------|----------|
| **LinkedIn** | All roles, especially senior |
| **WeAreDevelopers** | Tech talent |
| **Austrian Startups Jobs** | Startup-minded |
| **karriere.at** | General |
| **University career fairs** | Juniors |

### Salary Expectations
See `tech.md` for detailed tech salaries.

General startup adjustment: -10-20% vs corporate, offset by equity/experience.

### Employment Law Basics
- Notice periods: 6 weeks - 5 months (by tenure)
- Vacation: 25+ days mandatory
- Working hours: Max 40h/week (some flexibility)
- Termination: Can be complex, seek legal advice

---

## Taxes

### Corporate Tax
- **25% corporate tax** (KöSt)
- Minimum tax: €500/quarter (even if no profit)

### VAT
- Standard: 20%
- Reduced: 10% (food, books, etc.)
- Registration threshold: €35K revenue

### Founder Considerations
- Social security: ~25% of income (self-employed)
- Income tax: Progressive rates
- Tax advisor recommended (€200-400/month)

---

## IP & Legal

### Intellectual Property
- **Patent Office:** Austrian Patent Office (ÖPA)
- **EU protection:** Consider EU trademark/patent
- **University IP:** Negotiable, varies by institution

### Legal Help
- Several law firms specialize in startups
- Vienna Business Agency has legal hours
- ÖH (student union) offers free legal basics

---

## Working Spaces

### Co-working

| Space | Price | Vibe |
|-------|-------|------|
| **Impact Hub** | €75+/mo | Social impact |
| **weXelerate** | €590+/mo | Startup-corporate |
| **Sektor5** | Budget | Creative |
| **WeWork** | €300+/mo | Corporate |
| **Talent Garden** | Mid | International |

### Office Space
- Average: €15-25/m²/month (central)
- More affordable outside Ring

---

## International Expansion

### Vienna as HQ
- Good for: DACH + CEE expansion
- EU base for international companies
- English-friendly in tech

### Common Expansion Paths
1. **Austria first** (local validation)
2. **Germany** (large market, similar language)
3. **CEE** (Poland, Czech, Hungary)
4. **Western Europe** (UK, France, Nordics)

### Resources
- **Advantage Austria:** Export support
- **Vienna Business Agency:** International programs
- **Trade missions:** Regular events

---

## Visa for Founders

### Non-EU Founders

**Startup Visa (Rot-Weiß-Rot Karte for Start-up Founders):**
- Innovative business plan
- Sufficient funds (€50K+ recommended)
- Approval from AWS (economic agency)
- Valid 2 years

**Process:**
1. Business plan evaluation (AWS)
2. Visa application at embassy
3. 2-3 months processing

**Requirements:**
- No minimum capital
- Must be innovative/scalable
- Can include co-founders

---

## Networking

### Regular Events
- **Austrian Startups events** — Monthly
- **Pioneers Festival** — Annual large event
- **weXelerate Demo Days** — Quarterly
- **Meetups** — Various tech/startup groups

### Where to Network
- Impact Hub events
- Vienna Startup Week
- University startup events
- LinkedIn (very active in Vienna)

### Key People to Know
- Active angels (via Austrian Angel Network)
- VCs (Speedinvest, 3VC team)
- Austrian Startups community managers
- University tech transfer offices

---

## Resources

### Organizations
- **Austrian Startups:** austrianstartups.com
- **Vienna Business Agency:** viennabusinessagency.at
- **FFG:** ffg.at (research funding)
- **AWS:** aws.at (startup funding)
- **WKO:** wko.at (chamber of commerce)

### Media
- **Der Brutkasten:** Austrian startup news
- **trending topics:** Tech/startup coverage
- **Futurezone:** Tech news

### Databases
- **Austrian Startups Directory:** Find startups
- **Dealroom:** European startup data
- **Crunchbase:** Funding data

---

## Quick Checklist

### Week 1-2
- [ ] Validate idea locally
- [ ] Connect with Austrian Startups
- [ ] Visit Vienna Business Agency
- [ ] Check grant eligibility (FFG, AWS)

### Month 1-2
- [ ] Find co-working space
- [ ] Legal structure decision
- [ ] Notary for GmbH
- [ ] Bank account

### Month 3+
- [ ] Register company
- [ ] Apply for relevant grants
- [ ] Start hiring
- [ ] Join accelerator (if applicable)

---

## Success Tips

1. **Use government support** — Austria has excellent programs
2. **Network actively** — Small ecosystem, relationships matter
3. **Think DACH from day 1** — Austria alone is small
4. **Embrace English** — International team = advantage
5. **Consider grants** — Less dilution than equity
6. **Find local advisors** — Austrian business culture differs
7. **Be patient** — Things move slower than in US, but solid foundations
