# Vienna: Moving & Settling Guide

## First Steps After Arrival

### Week 1 Checklist
1. [ ] Register residence (Meldezettel) — **within 3 days**
2. [ ] Open bank account
3. [ ] Get SIM card
4. [ ] Arrange health insurance
5. [ ] Apply for residence permit (if non-EU)

---

## Residence Registration (Meldezettel)

**Mandatory within 3 days of moving in**

### What You Need
- Passport
- Completed Meldezettel form (available at office or online)
- Landlord signature on form (Unterkunftgeber)

### Where to Go
- **MA 62 offices** (Meldeservice)
- Any district office (Bezirksamt)
- [Online booking](https://www.wien.gv.at/amtshelfer/dokumente/meldezettel.html)

### Cost
- Free

### Tips
- Landlord MUST sign — this is your right by law
- Keep copies — you'll need Meldezettel for everything
- Update if you move within Austria

---

## Residence Permits (Non-EU)

### Types

| Type | For |
|------|-----|
| **Rot-Weiß-Rot Karte** | Skilled workers, key workers |
| **Rot-Weiß-Rot Karte Plus** | Family members, after 2 years |
| **Student Residence Permit** | Students |
| **Niederlassungsbewilligung** | Family reunification |

### Process
1. Apply at Austrian embassy (before arrival) or MA 35 (if legal residence)
2. Wait 3-6 months for processing
3. Collect biometric card

### MA 35 (Immigration Office)
- **Location:** Dresdner Straße 93
- **Appointments:** Online booking required, long waits
- **Documents:** Varies by permit type

### EU/EEA Citizens
- No work permit needed
- Register at MA 35 after 3 months
- Anmeldebescheinigung (registration certificate)

---

## Bank Account

### Major Banks

| Bank | Type | Notes |
|------|------|-------|
| **Erste Bank** | Traditional | Largest, good service |
| **Bank Austria** | Traditional | Part of UniCredit |
| **Raiffeisen** | Traditional | Strong network |
| **BAWAG** | Traditional | Reasonable fees |
| **N26** | Digital | Free, easy signup |
| **Revolut** | Digital | Good for travelers |

### Opening Account
**Traditional banks require:**
- Passport
- Meldezettel
- Proof of income (sometimes)
- In-person appointment (usually)

**Digital banks:**
- Passport + app signup
- No Meldezettel initially
- Quick verification

### Banking Tips
- Many still use cash for small purchases
- Direct debit (Lastschrift) common for bills
- Online banking (George app for Erste) excellent

---

## Health Insurance

### Mandatory System
Austria has mandatory health insurance (Sozialversicherung).

### If Employed
- Automatically enrolled through employer
- ÖGK (Österreichische Gesundheitskasse) is main provider
- Employer + employee contributions (~7.5% each)

### Self-Employed
- SVS (Sozialversicherungsanstalt der Selbständigen)
- Higher contributions (~25% of income)

### Students
- Must show proof of insurance
- Options: Home country insurance (EU card), student insurance, private

### Private Insurance
- Supplements public insurance
- Faster appointments, private rooms
- Major providers: Uniqa, Wiener Städtische, Allianz

### E-Card
- Your health insurance card
- Needed for doctor visits
- Arrives by mail after registration

---

## Phone & Internet

### Mobile Providers

| Provider | Type | Notes |
|----------|------|-------|
| **A1** | Major | Best coverage |
| **Magenta (T-Mobile)** | Major | Good urban coverage |
| **Drei** | Major | Budget-friendly |
| **HoT** | Budget | Hofer (Aldi) network |
| **Spusu** | Budget | Data-focused |
| **Bob** | Budget | A1 network |

### Typical Plans
- Budget: €10-15/month (10-20GB)
- Standard: €15-25/month (unlimited)
- Prepaid available at supermarkets

### Home Internet
- **A1, Magenta, Drei** — Main providers
- **Fonira, Kabelplus** — Regional options
- Speed: Usually 50-250 Mbps available
- Cost: €25-50/month

---

## Finding an Apartment

### Where to Search

| Platform | Type | Language |
|----------|------|----------|
| **willhaben.at** | All | German |
| **ImmobilienScout24** | All | German |
| **der Standard (immo)** | Quality | German |
| **WG-gesucht.de** | Shared | German |
| **Facebook groups** | Shared/All | Mixed |

### Typical Costs
- **Deposit:** 3 months rent (standard)
- **Broker fee:** Up to 2 months (sometimes)
- **First month:** Paid upfront

### Documents for Landlords
- Passport/ID
- Proof of income (3x rent recommended)
- Meldezettel (if have previous address)
- References (sometimes)

### Tips
- Competition is fierce for good flats
- German helps significantly
- Furnished more expensive
- "Provisionsfrei" = no broker fee

---

## Utilities

### What's Usually Included in Rent
- Building fees (Betriebskosten)
- Water (often)
- Garbage

### What's Usually Extra
- Electricity (Wien Energie main provider)
- Gas/heating (varies)
- Internet

### Setting Up
- **Wien Energie:** Online or phone signup
- Bring: Meldezettel, contract, meter readings
- Previous tenant's account auto-transfers usually

### Costs (85m² apartment)
- Electricity: €50-80/month
- Gas/heating: €60-150/month (seasonal)
- Water: Often included

---

## Learning German

### Free/Low-Cost Options
- **VHS (Volkshochschule):** Adult education, affordable
- **ÖIF courses:** For immigrants with Integrationsvereinbarung
- **Tandem partners:** Language exchange

### Paid Options
- **Goethe Institut:** Premium, recognized certificates
- **Berlitz:** Corporate-focused
- **Private tutors:** italki, Preply

### Reality Check
- English works in tourist areas, tech, universities
- German needed for: bureaucracy, daily life, most jobs
- B1-B2 recommended for comfortable life

---

## Important Offices

### MA 35 — Immigration
- Location: Dresdner Straße 93
- For: Residence permits, visa issues

### MA 62 — Registration
- Multiple locations
- For: Meldezettel, civil status

### AMS — Employment Office
- For: Unemployment benefits, job seeking

### Finanzamt — Tax Office
- For: Tax registration, employee tax card

### Magistrat — City Administration
- Various MA (Magistratsabteilung) offices for different needs

---

## Taxes

### Income Tax Rates (2026)

| Income (€/year) | Rate |
|-----------------|------|
| 0-12,816 | 0% |
| 12,816-20,818 | 20% |
| 20,818-34,513 | 30% |
| 34,513-66,612 | 41% |
| 66,612-99,266 | 48% |
| Over 99,266 | 50% |

### Key Points
- Employer handles payroll tax (Lohnsteuer)
- Annual tax return often beneficial (refunds)
- Tax ID (Steuernummer) needed
- Deadline: April 30 (paper) or June 30 (electronic)

---

## Cultural Integration

### Adapting to Vienna

**Expect:**
- Indirect communication (not German-direct)
- Love of titles (Herr Doktor, Frau Magister)
- Importance of greeting ("Grüß Gott")
- Quiet hours (10pm-6am, noon-3pm some buildings)
- Sunday closures

**Join:**
- Sports clubs (Verein)
- Expat groups (InterNations, etc.)
- Language tandems
- Neighborhood activities

### Making Friends
- Austrians are polite but reserved initially
- Friendships take time
- Expat community active and welcoming
- Shared hobbies best path in
