# Vienna: Local Services

## City Services (Magistrat Wien)

### Online Portal
- **wien.gv.at** — Main city portal
- Many services available online
- German required for most forms
- Account needed for some services

### Key Offices

| Office | Purpose |
|--------|---------|
| MA 35 | Immigration, residence permits |
| MA 62 | Registration (Meldezettel) |
| MA 40 | Social affairs |
| MA 48 | Waste management |
| MA 6 | Financial matters |

---

## Essential Services

### Electricity & Gas
**Wien Energie** — Main provider
- **Website:** wienenergie.at
- **Signup:** Online, phone, or in-person
- **Bills:** Monthly, direct debit common
- **Tips:** Compare prices (E-Control Tarifkalkulator)

### Water
- Usually included in rent (Betriebskosten)
- Vienna's water is excellent (Alpine springs)
- Safe to drink from tap

### Internet

| Provider | Speed | Price |
|----------|-------|-------|
| A1 | Up to 1 Gbps | €30-60 |
| Magenta | Up to 1 Gbps | €30-55 |
| Fonira | Up to 1 Gbps | €25-50 |

**Setup:** Often 1-2 weeks, technician visit sometimes needed

### Mobile Phone
See `resident.md` for detailed provider comparison.

---

## Mail & Packages

### Post (Österreichische Post)
- **Locations:** Post offices, partners (supermarkets)
- **Hours:** Usually 8am-6pm (varies)
- **Online:** post.at for tracking, services
- **PO boxes:** Available for rent

### Package Delivery
- **DHL, DPD, GLS, UPS** — All operate in Vienna
- **Pickup points:** Many partner locations
- **Amazon locker:** Available at various spots

### Tips
- Doorbells often don't work — packages left with neighbors or at pickup points
- Register with building if doorbells are tricky
- Evening/weekend delivery available (extra fee)

---

## Healthcare

### Finding a Doctor
- **Doctors search:** arztsuche.wgkk.at
- **Walk-in clinics:** Ambulatorien
- **Dental:** Zahnarzt, similar search tools

### Appointments
- **GP (Hausarzt):** Usually same/next day
- **Specialist:** May wait 1-4 weeks (public)
- **Private:** Faster but costs more

### Pharmacy (Apotheke)
- Regular hours: Mon-Fri 8am-6pm, Sat 8am-noon
- **24-hour pharmacies:** Rotating, check apothekerverband.at
- Green cross sign indicates pharmacy
- Pharmacist can advise on minor issues

### Emergency Care
- **Ambulance:** 144
- **ER (Notaufnahme):** At major hospitals
- **Doctor on call:** 141
- **Dental emergency:** Zahnärztlicher Notdienst (check online)

---

## Banking

### Services
- Online banking standard (excellent apps)
- ATMs throughout city
- Card payment widespread (not universal)
- Cash still important for small purchases

### Opening Account
See `resident.md` for bank comparison and requirements.

---

## Government Services

### Meldezettel (Registration)
- **Where:** MA 62, district offices
- **Online:** wien.gv.at
- **Cost:** Free
- **Timeline:** Do within 3 days of moving

### ID Card / Passport
- For Austrian citizens: Bezirksamt
- For renewal: Embassy of your country

### Driving License
- EU licenses: Valid
- Non-EU: May need to convert (Führerschein umschreiben)
- **Where:** ÖAMTC or Bezirksamt

### Car Registration
- **Where:** Bezirksamt
- Required for residents with cars

---

## Trash & Recycling

Vienna takes recycling seriously:

| Bin Color | Contents |
|-----------|----------|
| Yellow | Plastic, metal, beverage cartons |
| Blue | Paper, cardboard |
| Brown | Organic waste |
| Green | Glass (clear) |
| Brown glass | Glass (colored) |
| Black | Residual waste |

### Bulky Waste (Sperrmüll)
- Free collection: Book via 48er app or phone
- Mistplatz: Waste collection centers (free for residents)

### Tips
- Recycling bins at supermarkets for bottles
- Deposit (Pfand) on many bottles — return for €0.25
- 48er app for all waste questions

---

## Pets

### Dogs
- Registration required (Stadt Wien)
- Dog tax: ~€72/year
- Poop bags required (dispensers in parks)
- Leash rules vary by area

### Vets
- Many veterinary clinics
- TierQuarTier Wien: Animal rescue
- Emergency vets: 24-hour clinics available

### Pet-Friendly
- Many cafés and restaurants allow dogs
- Public transport: Dogs on leash OK
- Parks have designated dog areas

---

## Children

### Kindergarten
- **Public:** Free (meals extra ~€100)
- **Private:** €200-600/month
- **Waitlists:** Apply early (September for following year)
- **Where:** MA 10, online applications

### Schools
- **Public schools:** Free, by district
- **International schools:** €800-2,500/month
- **Registration:** Through school directly

### Playgrounds
- Abundant throughout city
- Well-maintained
- Indoor play areas (winter)

### Family Services
- **Kinderinfo:** wien.gv.at family portal
- **MA 11:** Child and youth services
- **Familienkarte:** Discounts for families

---

## Fitness & Sports

### Gyms
- **John Harris:** Premium
- **Fitness First:** Mid-range
- **McFit:** Budget
- **Boutique gyms:** Various

### Public Pools
- **Schönbrunner Bad:** Outdoor, beautiful
- **Gänsehäufel:** Danube beach/pool
- **Stadthallenbad:** Indoor, central
- Prices: ~€5-8

### Running
- Prater: Huge park, popular
- Danube Canal: Paved path
- Ringstrasse: Early morning

### Cycling
- Extensive bike lane network
- Donauinsel: Car-free 21km
- Vienna Woods: Mountain biking

---

## Libraries

### Vienna Public Libraries (Büchereien Wien)
- Multiple branches
- Free membership for residents
- Books, eBooks, media
- Study spaces

### University Libraries
- Open to public (reading)
- Borrowing requires affiliation

---

## Community Services

### Expat Resources
- **InterNations:** Expat events
- **Vienna Expats:** Facebook group
- **Meetup:** Various groups

### Language Exchange
- **Tandem:** Language partner apps
- **Conversation groups:** VHS, cultural centers

### Volunteering
- **freiwilligenweb.at:** Volunteer opportunities
- Red Cross, Caritas, local organizations

---

## Useful Contacts

| Service | Contact |
|---------|---------|
| City hotline | 01 4000 |
| Police | 133 |
| Fire | 122 |
| Ambulance | 144 |
| Poison control | 01 406 43 43 |
| Women's helpline | 01 71 71 9 |
| Domestic abuse | 0800 222 555 |
| Consumer protection | 01 50165 |

### Lost & Found
- **Fundservice:** fundservice.wien.at
- Check public transport lost and found (Wiener Linien)
