# Vienna: Traditional Cuisine

## Iconic Dishes

### Wiener Schnitzel
**Austria's national dish** — thin veal cutlet, breaded and fried to golden perfection.

**The Rules:**
- Authentic = veal (Kalbsschnitzel)
- Pork version = Schweinsschnitzel (cheaper, also good)
- Breading should "wave" slightly off the meat
- Served with potato salad or parsley potatoes
- Never with sauce (that's German, not Austrian)

**Best Places:**
| Restaurant | Price | Notes |
|------------|-------|-------|
| **Figlmüller** | €18-25 | Famous, huge portions, tourist crowds |
| **Plachutta** | €22-30 | High quality, elegant |
| **Gasthaus Kopp** | €16-22 | Local favorite, no frills |
| **Schnitzelwirt** | €14-20 | Traditional, value |
| **Zum Figlmüller (Bäckerstrasse)** | €18-25 | Less crowded than main |

**Tip:** Skip the tourist-trap Figlmüller if you want authenticity. Locals go to Gasthaus Kopp or Schnitzelwirt.

---

### Tafelspitz
**Emperor Franz Joseph's favorite** — prime boiled beef served ceremoniously.

**The Experience:**
1. Broth served first as soup
2. Beef arrives with bone marrow
3. Accompanied by: apple-horseradish (Apfelkren), chive sauce, roasted potatoes
4. Often served tableside from copper pot

**The Place:** Plachutta Wollzeile — undisputed king, 13 different cuts available

**Price:** €28-42 per person

**Note:** This is a multi-course experience. Don't rush it.

---

### Other Main Dishes

| Dish | Description | Where |
|------|-------------|-------|
| **Backhendl** | Crispy fried chicken, lighter than Schnitzel | Gasthaus Kopp, Zum weißen Rauchfangkehrer |
| **Schweinsbraten** | Roast pork with crackling, dumplings, sauerkraut | Any traditional Beisl |
| **Zwiebelrostbraten** | Beef with crispy fried onions | Am Nordpol 3 |
| **Gulasch** | Hungarian-influenced beef stew | Fiakergulasch anywhere |
| **Beuschel** | Veal heart and lung ragout (adventurous) | Traditional Beisln |
| **Knödel** | Bread or potato dumplings | Heuriger buffets |
| **Frittatensuppe** | Beef broth with sliced pancake strips | Any traditional place |

---

## Desserts

### Sachertorte
**Vienna's most famous cake** — dense chocolate with apricot jam layer, chocolate glaze.

**The Rivalry:**
- **Hotel Sacher** — claims the "original" recipe
- **Demel** — claims their version is better
- Both are excellent, slightly different

**Price:** €8-12 per slice
**Where:** Sacher, Demel, or any good café

### Apfelstrudel
**Apple strudel** — paper-thin pastry filled with apples, raisins, cinnamon.

**Best served:** Warm with vanilla sauce or whipped cream

**Best:** Café Central, Café Landtmann, traditional cafés

### More Desserts

| Sweet | Description |
|-------|-------------|
| **Kaiserschmarrn** | Shredded pancake with powdered sugar, plum compote |
| **Palatschinken** | Thin crepes with jam, Nutella, or sweet cheese |
| **Punschkrapfen** | Pink-glazed rum sponge cake |
| **Linzer Torte** | Almond-raspberry tart with lattice |
| **Topfenstrudel** | Sweet cheese strudel |
| **Marillenknödel** | Apricot dumplings (seasonal) |
| **Buchteln** | Sweet yeast buns with vanilla sauce |

---

## Best Traditional Restaurants

### Beisl (Traditional Taverns)

**Top Tier:**
| Name | District | Specialty | Price |
|------|----------|-----------|-------|
| **Gasthaus Kopp** | 1st | Schnitzel, classics | €€ |
| **Zum weißen Rauchfangkehrer** | 1st | Traditional, since 1890 | €€ |
| **Steman** | 8th | Locals only, authentic | €€ |
| **Gmoa Keller** | 1st | Underground, character | €€ |
| **Am Nordpol 3** | 2nd | Bohemian influence | €€ |

**Also Good:**
- **Figlmüller (Bäckerstrasse)** — Less touristy location
- **Plutzer Bräu** — Brew pub with traditional food
- **Glacis Beisl** — Near MuseumsQuartier
- **Silberwirt** — 5th district, locals

### Upscale Traditional
- **Plachutta** — Multiple locations, Tafelspitz king
- **Mraz & Sohn** — Modern traditional, Michelin
- **Steirereck** — Austrian ingredients, 2 Michelin stars

---

## Sausages (Würstel)

### Würstelstand Culture
Vienna's iconic sausage stands — open late, cheap, beloved.

**Classic Order:**
- "Käsekrainer" — cheese-filled sausage (most popular)
- "A Eitrige" (slang for Käsekrainer) = You're a local
- Served with bread (Semmel), mustard, horseradish

**Types:**
| Sausage | Description |
|---------|-------------|
| **Käsekrainer** | Cheese-stuffed, the favorite |
| **Frankfurter** | Classic boiled |
| **Burenwurst** | Coarse, smoky |
| **Debreziner** | Spicy Hungarian style |
| **Bosna** | Balkan-style in bread |

**Best Stands:**
- **Bitzinger** — Near Opera, famous
- **Zum scharfen René** — Schwedenplatz
- **LEO** — Various locations
- Any stand at 2am after nightlife

---

## Seasonal Specialties

### Spring
- **Bärlauch** (wild garlic) — In everything
- **Spargel** (white asparagus) — April-June obsession

### Summer
- **Marillenknödel** — Apricot dumplings
- **Sturm** — Young fermenting wine (August-October)

### Fall
- **Wild** — Game dishes (venison, wild boar)
- **Schwammerl** — Wild mushrooms
- **Martinigansl** — St. Martin's goose (November)

### Winter
- **Punsch** — Hot spiced wine at Christmas markets
- **Lebkuchen** — Gingerbread
- Heavy stews and roasts

---

## Ordering Tips

### German Phrases
- "Ich hätte gerne..." — I would like...
- "Was empfehlen Sie?" — What do you recommend?
- "Ist das vegetarisch?" — Is that vegetarian?
- "Zahlen, bitte" — Check, please
- "Das war sehr gut" — That was very good

### Meal Structure
Traditional Austrian meal:
1. Soup (Suppe) — often beef broth
2. Main (Hauptgericht)
3. Dessert (Nachspeise) or coffee

### Portions
Austrian portions are generous. One main is usually enough.

---

## Common Mistakes

1. **Asking for sauce on Schnitzel** — Never done
2. **Ordering Schnitzel with rice** — Austrians cringe
3. **Rushing Tafelspitz** — It's a ceremony
4. **Expecting fast service** — Traditional restaurants take time
5. **Not trying Käsekrainer** — The true Vienna experience
6. **Only going to Figlmüller** — There are better options

---

## Vegetarian Note

Traditional Viennese cuisine is meat-heavy. Vegetarian options:
- Kasnocken (cheese dumplings)
- Käsespätzle (cheese noodles)
- Semmelknödel (bread dumplings) with sauce
- Side dishes as mains
- Most desserts

For better vegetarian options, see modern restaurants in `food-overview.md`.
