# Vienna: Practical Food Info

## Dietary Requirements

### Vegetarian
Vienna has improved significantly:

**Dedicated Vegetarian/Vegan:**
- **Tian** — Michelin-starred vegetarian
- **Yamm!** — Buffet, vegan-friendly
- **Swing Kitchen** — Vegan fast food chain
- **Veggiezz** — Vegan burgers
- **Hollerei** — Organic vegetarian

**Traditional Options:**
- Käsespätzle (cheese noodles)
- Kasnocken (cheese dumplings)
- Erdäpfelgulasch (potato goulash)
- Most desserts

**Reality:** Traditional Beisln have limited veggie options. Specify clearly: "Ich bin Vegetarier/in."

### Vegan
Harder at traditional restaurants, easy at modern ones:
- **Swing Kitchen** — Best vegan fast food
- **Yamm!** — Good selection
- **Veganista** — Ice cream
- Asian restaurants (ask about fish sauce)

**Phrase:** "Ich bin vegan" — no eggs, dairy, or animal products

### Gluten-Free
Less common than some cities:
- Ask: "Haben Sie glutenfreie Optionen?"
- Better at international restaurants
- Supermarkets have gluten-free sections (Spar, Billa)
- Schnitzel is NOT gluten-free (breadcrumbs)

### Halal
- **Naschmarkt** — Multiple halal options
- **Brunnenmarkt (16th)** — Many halal butchers
- Turkish restaurants (ask to confirm)
- Some döner places are certified

### Kosher
- **Alef Alef** — 2nd district (historic Jewish quarter)
- Limited options; 2nd district best area

---

## Grocery Shopping

### Supermarket Chains

| Chain | Level | Notes |
|-------|-------|-------|
| **Billa** | Standard | Most common, reliable |
| **Billa Plus** | Larger | Better selection, good prepared food |
| **Spar** | Standard | Similar to Billa |
| **Hofer** | Discount | Austrian Aldi, best prices |
| **Lidl** | Discount | Budget option |
| **Penny** | Discount | Budget |
| **Merkur** | Premium | Higher quality (now part of Billa) |
| **Meinl am Graben** | Luxury | Specialty, expensive |

### Specialty Stores
- **Meinl am Graben** — Gourmet everything
- **Staud's** — Jams, preserves, Viennese specialty
- **Käsewolf** — Cheese specialist
- **Radatz** — Traditional butcher chain
- **Vinothek St. Stephan** — Wine

### Shopping Hours
- **Regular:** Mon-Fri 7am-7pm, Sat until 6pm
- **Sunday:** CLOSED (almost everywhere)
- **Train stations:** Open Sundays (Hauptbahnhof, Westbahnhof)
- **Plan ahead** for Sunday!

### Tips
- Bring reusable bags (plastic bags charged)
- Weigh produce yourself at machines (code on sign)
- Bakery section often best value
- "Bio" = Organic

---

## Restaurant Reservations

### Where to Book
- **Popular Beisln:** Call or email 1-2 days ahead for weekend dinner
- **Fine dining:** Book 1-2 weeks ahead
- **Casual:** Usually walk-in okay

### Platforms
- **Quandoo** — Most common
- **Google** — Many accept through Maps
- **Phone** — Still common, German helps
- **Email** — Mention party size, date, time

### Peak Times
- **Lunch:** 12:00-1:30pm
- **Dinner:** 7:00-9:00pm
- **Hardest reservations:** Friday/Saturday dinner, Sunday lunch

---

## Tipping

### Guidelines

| Situation | Tip |
|-----------|-----|
| Restaurant (full service) | 5-10% |
| Café (table service) | Round up + small change |
| Bar | Round up |
| Takeaway | None expected |
| Coat check | €1-2 |
| Bathroom attendant | €0.50-1 |

### How to Tip
- Say amount you want to pay when paying
- Example: Bill is €17.50, say "Neunzehn" (€19) — includes tip
- Or leave coins on table
- Card tips: Often ask "How much total?"

### Note
Austrians don't overtip. 5-10% is normal and appreciated. 20% would be excessive.

---

## Food Delivery

### Apps

| App | Coverage | Notes |
|-----|----------|-------|
| **Lieferando** | Best | Most restaurants |
| **Foodora** | Good | Similar coverage |
| **Mjam** | Good | Popular locally |
| **Wolt** | Growing | Quality restaurants |

### Delivery Fees
- Usually €2-5 depending on distance and restaurant
- Minimum orders often €10-15

### What Delivers Well
- ✅ Pizza, Asian, Middle Eastern
- ❌ Schnitzel (gets soggy)
- ❌ Traditional Austrian (better in-person)

---

## Meal Times

### Typical Schedule

| Meal | Time | Notes |
|------|------|-------|
| **Breakfast** | 7-10am | Most cafés serve until 11am+ |
| **Lunch** | 12:00-2:00pm | "Mittagsmenü" (lunch special) |
| **Jause** | 3-5pm | Coffee + cake (traditional) |
| **Dinner** | 6:30-9:00pm | Kitchens often close 9:30-10pm |

### Late Night
- **Würstelstands:** Open late (some 24h)
- **Döner shops:** Until 2-4am
- **Late restaurants:** Limited options
- **McDonald's:** 24h at some locations

---

## Water

### Tap Water
- **Excellent quality** — Alpine spring water
- **Free refills:** Public fountains throughout city
- **Restaurants:** Ask for "Leitungswasser" (tap water)
  - Some give it free
  - Some refuse (prefer selling bottles)
  - Some charge small fee

### Bottled Water
- **Restaurants:** €2-4 per bottle
- **Supermarkets:** €0.30-1.50
- Römerquelle, Vöslauer are local brands

---

## Food Allergies

### Communication
- **Allergen info:** EU law requires restaurants to inform
- Common allergens labeled: A-R codes (ask for key)
- Staff usually aware of major allergens

### Key Phrases
- "Ich habe eine Allergie gegen..." (I have an allergy to...)
- Nüsse = nuts
- Milch = milk
- Eier = eggs
- Weizen = wheat
- Meeresfrüchte = seafood
- Erdnüsse = peanuts

### Emergency
- Allergic reaction: Call 144 (ambulance)
- Pharmacies (Apotheke): Can help with minor reactions

---

## Food Safety

Vienna maintains high standards:
- EU food safety regulations strictly enforced
- Markets inspected regularly
- Restaurant kitchens generally clean
- Tap water safe everywhere

### Street Food
- Würstelstands: Regulated, safe
- Naschmarkt: Generally safe, use judgment
- Keep hot food hot, cold food cold
