# Vienna Food Overview

Vienna is a culinary paradise where imperial traditions meet modern innovation. From crispy Schnitzel to legendary coffeehouses, the city offers one of Europe's most distinctive food scenes.

---

## The Essentials

### Must-Try Dishes

| Dish | Description | Where |
|------|-------------|-------|
| **Wiener Schnitzel** | Breaded veal cutlet, golden perfection | Figlmüller, Plachutta, Gasthaus Kopp |
| **Tafelspitz** | Boiled beef, Franz Joseph's favorite | Plachutta Wollzeile |
| **Sachertorte** | Chocolate cake with apricot jam | Hotel Sacher, Demel |
| **Apfelstrudel** | Apple strudel, warm with vanilla sauce | Any traditional café |
| **Kaiserschmarrn** | Shredded pancake with plum compote | Traditional restaurants |
| **Melange** | Viennese cappuccino | Any coffeehouse |

### Price Ranges

| Type | Meal Cost |
|------|-----------|
| Würstelstand (sausage) | €3-6 |
| Bakery lunch | €4-8 |
| Beisl (tavern) lunch | €10-15 |
| Mid-range dinner | €20-35 |
| Fine dining | €60-150+ |

---

## Restaurant Categories

### Beisl (Traditional Tavern)
The Viennese bistro — unpretentious local food, reasonable prices

**Best:**
- **Gasthaus Kopp** — Classic near Stephansplatz
- **Zum weißen Rauchfangkehrer** — Institution since 1890
- **Gmoa Keller** — Underground atmosphere
- **Am Nordpol 3** — Bohemian influence

### Heuriger (Wine Tavern)
Working vineyards serving their own wine + buffet. Unique to Vienna.

**Best:**
- **Wieninger am Nussberg** — City views, excellent wines
- **Mayer am Nussberg** — Traditional, family-run
- **10er Marie** — Historic, locals' favorite

See `food-markets.md` for detailed Heuriger guide.

### Fine Dining
Vienna has excellent high-end options:

- **Steirereck** — 2 Michelin stars, best in Austria
- **Amador** — 2 Michelin stars, creative
- **Konstantin Filippou** — 2 Michelin stars
- **Silvio Nickol** — In Palais Coburg, wine pairing excellence

### International

| Cuisine | Where to Find |
|---------|---------------|
| Turkish/Middle Eastern | Brunnenmarkt (16th), Naschmarkt |
| Asian | Kettenbrückengasse area, 6th/7th |
| Italian | Throughout (quality varies) |
| Indian | Schwedenplatz area |
| Japanese | 1st district, Naschmarkt |

---

## Best Areas for Eating

### 1st District — Tourist + High-End
- Famous coffeehouses (Sacher, Central)
- Tourist trap restaurants (avoid Stephansplatz)
- Fine dining
- Expensive

### 4th District (Wieden) — Foodie Paradise
- Naschmarkt stalls
- International options
- Freihausviertel restaurants
- Best variety

### 7th District (Neubau) — Hip + International
- Trendy restaurants
- Brunch spots
- International cuisines
- Young crowd

### 2nd District (Leopoldstadt) — Emerging
- Karmelitermarkt area
- Jewish cuisine
- Local favorites
- Good value

### 16th District — Authentic Multicultural
- Brunnenmarkt
- Turkish, Balkan food
- Budget-friendly
- Adventurous eating

---

## Dining Etiquette

### Arriving
- Reservations recommended for dinner (especially weekends)
- "Grüß Gott" when entering
- Wait to be seated at restaurants

### Ordering
- Water often charged (€2-4)
- Tap water: ask for "Leitungswasser" (sometimes free, sometimes refused)
- Bread basket charged at some places

### Tipping
- 5-10% for good service
- Round up for small bills
- Leave on table or hand to server
- Don't split bills into tiny amounts (considered cheap)

### Paying
- "Zahlen, bitte" — bill please
- Card accepted most places (not all traditional spots)
- Lunch specials (Mittagsmenü) are great value

---

## Budget Eating

### Cheap & Good

| Option | Price | Notes |
|--------|-------|-------|
| **Würstelstand** | €3-6 | Iconic sausage stands, open late |
| **Bäckerei** | €2-5 | Bakery sandwiches |
| **Naschmarkt stalls** | €5-12 | Not sit-down restaurants |
| **University Mensa** | €5-8 | Open to public |
| **Billa/Spar** | €4-8 | Supermarket prepared food |
| **Döner Kebab** | €5-7 | Ubiquitous, filling |

### Lunch Deals
- "Mittagsmenü" — fixed lunch menu, usually €10-15
- Available 11:30am-2:30pm
- Best value at traditional restaurants

---

## Vegetarian & Special Diets

### Vegetarian-Friendly

Vienna has caught up:
- **Tian** — Michelin-starred vegetarian
- **Yamm!** — Buffet, vegan options
- **Swing Kitchen** — Vegan fast food chain
- Most restaurants have vegetarian options

### Gluten-Free
- Less common than some cities
- Ask: "Haben Sie glutenfreie Optionen?"
- Better at international restaurants

### Halal
- Naschmarkt area
- Brunnenmarkt (16th)
- Ask at Turkish restaurants

---

## Seasonal Highlights

### Spring (Mar-May)
- White asparagus (Spargel) season
- First outdoor dining

### Summer (Jun-Aug)
- Heuriger season peak
- Outdoor markets
- Festival food

### Fall (Sep-Nov)
- Wine harvest (Sturm — young wine)
- Game dishes (wild boar, venison)
- Mushroom season

### Winter (Dec-Feb)
- Christmas market food (Punsch, Lebkuchen)
- Hearty stews
- Cozy coffeehouse season

---

## Quick Recommendations

### First-Timer Must-Dos
1. Schnitzel at a real Beisl (not Figlmüller tourist trap)
2. Sachertorte at Hotel Sacher or Demel
3. Coffee at a historic coffeehouse
4. Heuriger evening in Grinzing or Nussberg
5. Naschmarkt browsing

### Local Secrets
- **Schweizerhaus** in Prater — Stelze (pork knuckle) + Czech beer
- **Steman** — Traditional Beisl, no tourists
- **Zum Schwarzen Kameel** — Standing at bar for sandwiches
- **Café Rüdigerhof** — Real Viennese café, no tourists

### Avoid
- Any restaurant ON Stephansplatz
- Naschmarkt sit-down restaurants (stalls are better)
- Mozart-themed tourist traps
- €5 "Schnitzel" places

See also: `food-traditional.md`, `food-coffee.md`, `food-markets.md`, `food-practical.md`
