# Vienna: Markets & Heurigen

## Naschmarkt

**Vienna's most famous market** — 1.5km of food stalls, restaurants, and weekend flea market.

### The Basics
- **Location:** Between Karlsplatz and Kettenbrückengasse (4th/6th district)
- **Metro:** U1/U4 Karlsplatz, U4 Kettenbrückengasse
- **Hours:** Mon-Fri 6am-7:30pm, Sat 6am-6pm
- **Flea market:** Saturday 6am-2pm (arrive early!)
- **Closed:** Sundays

### What to Find
- Fresh produce (expensive but quality)
- International foods (Turkish, Greek, Asian, Indian)
- Cheese and charcuterie
- Spices and dried goods
- Seafood
- Prepared foods to go
- Olive oils, vinegars

### Pro Tips
1. **Browse stalls, not restaurants** — Sit-down places have 50%+ markup
2. **Best value:** Turkish stalls, Asian prepared foods
3. **Expensive:** Seafood, specialty cheese (buy at supermarket instead)
4. **Flea market:** Get there by 7am for good finds
5. **Walk the whole thing** — Quality varies, compare prices

### Eating There
- **Stall food:** Great value, eat standing or take away
- **Sit-down restaurants:** Tourist trap prices
- **Best:** Grab items, sit in nearby park

---

## Other Markets

### Brunnenmarkt (16th District)
**Vienna's longest market street** — Multicultural, authentic, cheap

- **Location:** Brunnengasse, between Thaliastraße and Ottakringer Straße
- **Metro:** U6 Josefstädter Straße or Thaliastraße
- **Hours:** Mon-Fri 6am-6:30pm, Sat 6am-5pm
- **Vibe:** Turkish, Balkan, Middle Eastern — real Vienna diversity
- **Prices:** Much cheaper than Naschmarkt
- **Best for:** Produce, spices, authentic ethnic food

### Karmelitermarkt (2nd District)
**Trendy neighborhood market** — Locals, foodies, organic

- **Location:** Leopoldstadt
- **Metro:** U2 Taborstraße
- **Hours:** Mon-Fri 6am-7:30pm, Sat 6am-5pm
- **Vibe:** Young, organic, farmers market feel
- **Best for:** Quality produce, brunch spots around the market

### Viktor-Adler-Markt (10th District)
**Working class market** — Cheapest produce, authentic

- **Location:** Favoritenstraße
- **Metro:** U1 Reumannplatz
- **Hours:** Mon-Fri 6am-6pm, Sat 6am-2pm
- **Vibe:** Multicultural, budget
- **Best for:** Produce on a budget

### Rochusmarkt (3rd District)
**Small neighborhood market** — Local, no tourists

- **Location:** Near Rochuskirche
- **Hours:** Mon-Fri 6am-6pm, Sat 6am-1pm
- **Best for:** Quick authentic shopping

### Kutschkermarkt (18th District)
**Upscale neighborhood market**

- **Location:** Währing
- **Hours:** Mon-Fri 6am-6pm, Sat 6am-1pm
- **Best for:** Quality + farmers market on Saturdays

---

## Heurigen (Wine Taverns)

### What Are They?
**Working vineyards serving their own wine** — Unique to Vienna and surroundings.

A "Heuriger" is where a winemaker sells their own wine (the term means "this year's"). They also serve cold buffets. It's a centuries-old tradition protected by law.

### The Experience
1. Enter, find a table (often communal)
2. Order wine by the "Viertel" (quarter liter) or "Achtel" (eighth)
3. Get food from the buffet (cold cuts, spreads, breads, salads)
4. Sit in the garden (Gastgarten) if weather permits
5. Stay until the wine runs out or you do

### Best Heurigen

#### Nussberg Area (Stunning Views)
| Name | Notes |
|------|-------|
| **Wieninger am Nussberg** | Best views of Vienna, excellent wines, modern |
| **Mayer am Nussberg** | Traditional, family-run generations |
| **Fuhrgassl-Huber** | Huge, popular, great terrace |

**To get there:** Bus 38A from Heiligenstadt (U4) to Nussberg, then walk

#### Grinzing (Tourist Classic)
| Name | Notes |
|------|-------|
| **Zimmermann** | Traditional, less touristy than neighbors |
| **Bach-Hengl** | Good wines, nice garden |

**Reality check:** Grinzing is the most touristy area. Nice but less authentic than Nussberg.

**To get there:** Tram 38 from Schottentor

#### Stammersdorf (Local Favorite)
| Name | Notes |
|------|-------|
| **Göbel** | Excellent wines, true locals' spot |
| **Wieninger** | Same family as Nussberg location |

**To get there:** Bus 31A from Floridsdorf (U6)

#### Within the City
| Name | Location | Notes |
|------|----------|-------|
| **10er Marie** | 16th district | Historic, within city |
| **Wolff** | 19th district | Award-winning wines |

### Heuriger Vocabulary

| Term | Meaning |
|------|---------|
| **Heuriger** | The establishment (and this year's wine) |
| **Buschenschank** | Similar, but even more traditional |
| **Viertel** | Quarter liter of wine |
| **Achtel** | Eighth liter |
| **G'spritzer** | Wine with soda water |
| **Sturm** | Young fermenting wine (August-October) |
| **Ausg'steckt** | "Open" — green branch indicates they're serving |

### Heuriger Tips
1. **Check if open** — Many rotate schedules, check websites
2. **Bring cash** — Many don't take cards
3. **Go for sunset** — Best atmosphere
4. **Try Sturm** (Aug-Oct) — Cloudy, sweet, deceptively strong
5. **Take a hike first** — Combine with vineyard walk
6. **Season:** April-October best, some open year-round

### Prices
- **Wine (Viertel):** €3-5
- **Buffet plate:** €8-15
- **Total evening:** €25-40 per person

---

## Christmas Markets

### November-December 23

| Market | Location | Best For |
|--------|----------|----------|
| **Rathausplatz** | City Hall | Biggest, most magical |
| **Schönbrunn** | Palace | Elegant setting |
| **Spittelberg** | 7th district | Artisan, cozy streets |
| **Belvedere** | 3rd district | Intimate, art focus |
| **Karlsplatz** | 4th district | Art and design crafts |
| **Am Hof** | 1st district | Historic square |

### What to Eat/Drink
- **Punsch** — Hot spiced wine/rum (various flavors)
- **Glühwein** — Mulled wine
- **Maroni** — Roasted chestnuts
- **Kartoffelpuffer** — Potato pancakes
- **Lebkuchen** — Gingerbread
- **Langos** — Hungarian fried dough

### Tips
- **Weekday evenings** — Less crowded
- **Bring cash** — Not all stalls take cards
- **Mug deposits:** Usually €4-5, keep mug or return for refund
- **Rathausplatz:** Best for atmosphere but most crowded

---

## Farmers Markets

### Saturday Mornings

| Market | Location | Notes |
|--------|----------|-------|
| **Karmelitermarkt** | 2nd district | Best for expats |
| **Kutschkermarkt** | 18th district | Upscale, organic |
| **Brunnenmarkt** | 16th district | Cheapest |
| **Naschmarkt flea market** | 4th district | Junk to treasures |

### Organic/Bio Markets
- **BioMarkt at Freyung** — Fridays and Saturdays
- **ab Hof** markets — Direct from farm
