# Vienna Coffee House Culture

## UNESCO Intangible Cultural Heritage

Since 2011, Viennese coffeehouse culture has been recognized by UNESCO — "a place where time and space are consumed, but only the coffee is found on the bill."

---

## The History

The legend: After the 1683 Ottoman siege, liberators found sacks of coffee beans. Reality: The first Viennese coffeehouse opened in 1685 by Armenian merchant Johannes Theodat.

By the late 19th century, coffeehouses became intellectual salons where **Stefan Zweig, Sigmund Freud, Gustav Klimt, Egon Schiele, Adolf Loos, Leon Trotsky**, and countless others gathered.

When Austrian intelligence dismissed concerns about Trotsky, they reportedly said: *"Revolution? From Herr Bronstein from Café Central?"*

---

## Coffee Menu

### Essential Orders

| Name | Description |
|------|-------------|
| **Melange** | Vienna's cappuccino — espresso with steamed milk foam |
| **Kleiner Brauner** | Small espresso with milk on the side |
| **Großer Brauner** | Large espresso with milk on the side |
| **Einspänner** | Strong black coffee in glass, topped with whipped cream |
| **Verlängerter** | Diluted espresso — Vienna's "Americano" |
| **Kapuziner** | Espresso with dash of cream |
| **Wiener Eiskaffee** | Cold coffee with vanilla ice cream and whipped cream |
| **Franziskaner** | Melange with whipped cream instead of foam |
| **Türkischer** | Turkish-style in copper pot |
| **Schwarzer** | Black coffee (small = kleiner, large = großer) |

### Pro Tip
Order by proper name. "Cappuccino" will work, but "Melange" shows you know the culture.

---

## Historic Coffeehouses

### Café Central ⭐
**The most famous** — Where intellectuals gathered, Trotsky played chess

- **Location:** Herrengasse 14, 1st district
- **Atmosphere:** Grand, palatial, piano music
- **Best for:** First-time visitors, the experience
- **Reality check:** Very touristy, queues likely, high prices
- **Hours:** Mon-Sat 8am-10pm, Sun 10am-10pm

### Café Sacher
**Home of the original Sachertorte**

- **Location:** In Hotel Sacher, behind Opera
- **Atmosphere:** Elegant, red velvet, imperial
- **Best for:** Sachertorte ritual
- **Reality check:** Expensive, tourist-heavy, worth once
- **Price:** Sachertorte slice ~€9

### Demel
**Imperial confectioner since 1786**

- **Location:** Kohlmarkt 14, 1st district
- **Atmosphere:** Baroque elegance, pastry displays
- **Best for:** Pastries, their Sachertorte version
- **Specialty:** Watch chocolatiers work through window
- **Note:** No waiter service — order at counter

### Café Hawelka
**Bohemian artists' café** — No renovations since 1939

- **Location:** Dorotheergasse 6, 1st district
- **Atmosphere:** Dark, smoky (historically), authentic
- **Best for:** Bohemian vibe, Buchteln after 10pm
- **Specialty:** Buchteln (sweet buns) — only served evenings

### Café Landtmann
**Politicians' and journalists' café** — Next to Rathaus

- **Location:** Dr.-Karl-Lueger-Ring 4
- **Atmosphere:** Elegant, professional crowd
- **Best for:** Breakfast, newspapers, people-watching
- **Note:** Freud was a regular

### Café Sperl
**Artists' café** — More authentic than Central

- **Location:** Gumpendorfer Str. 11, 6th district
- **Atmosphere:** Belle Époque, pool tables, artists
- **Best for:** Locals + atmosphere without tourists
- **Closed:** Sundays in July-August

### Café Prückel
**1950s retro** — Untouched mid-century design

- **Location:** Stubenring 24
- **Atmosphere:** Retro, slightly faded, authentic
- **Best for:** Feeling like you stepped back in time

---

## Non-Touristy Favorites

### Café Rüdigerhof
**Real Viennese neighborhood café**

- **Location:** Near U4 Pilgramgasse
- **Why:** No tourists, regulars at same tables for decades
- **Evening:** Transforms to beer garden atmosphere

### Café Jelinek
**Student/artistic crowd**

- **Location:** 6th district
- **Why:** Untouched, authentic, young crowd

### Café Weimar
**Near University**

- **Location:** 9th district
- **Why:** Academic atmosphere, chess players

### Vollpension
**Intergenerational café** — Grandmas bake the cakes

- **Location:** 4th district near Naschmarkt
- **Why:** Great concept, excellent homemade cakes

---

## Third Wave / Specialty Coffee

Vienna's specialty coffee scene has exploded:

| Café | Location | Style |
|------|----------|-------|
| **Jonas Reindl** | Multiple | Specialty espresso, modern |
| **Kaffeemik** | 6th | Single origin, serious |
| **Kaffeefabrik** | 4th | Roasters, industrial chic |
| **Balthasar** | 1st | Hidden, excellent |
| **Phil** | 6th | Books + coffee + furniture for sale |

**Note:** Traditional coffeehouses use Julius Meinl or similar blends. For specialty beans, go third wave.

---

## Coffeehouse Etiquette

### The Rules
1. **Stay as long as you want** — One coffee = hours of sitting
2. **Water comes automatically** — Free, on a silver tray
3. **The waiter is aloof** — It's tradition, not rudeness
4. **Ask for the bill** — "Zahlen, bitte" — it won't come otherwise
5. **Newspapers provided** — Read the international press
6. **Tip 5-10%** — Round up or leave coins

### What Not to Do
- Don't ask for wifi password immediately (many don't have it)
- Don't rush
- Don't ask for decaf at traditional places
- Don't ask for takeaway cups
- Don't treat it like Starbucks

---

## Best For...

### Best for First-Timers
**Café Central** — Despite tourists, the experience is worth it once

### Best for Authentic Experience
**Café Sperl** — What a real Viennese coffeehouse should be

### Best for Cakes
**Demel** — Unmatched pastry selection

### Best for Locals' Feel
**Café Rüdigerhof** or **Café Jelinek**

### Best for Third Wave
**Jonas Reindl** or **Kaffeemik**

### Best for Breakfast
**Café Landtmann** — Excellent breakfast, newspapers

---

## Prices

| Item | Traditional Café | Specialty Café |
|------|------------------|----------------|
| Melange | €4.50-6.00 | €3.50-5.00 |
| Sachertorte | €7-9 | — |
| Apfelstrudel | €6-8 | — |
| Breakfast | €12-18 | €10-14 |

**Note:** Traditional cafés are more expensive but include the experience.

---

## When to Visit

### Best Times
- **Morning (9-11am):** Locals reading newspapers
- **Afternoon (3-5pm):** "Jause" — traditional cake time
- **Evening:** Different atmosphere, sometimes live music

### Avoid
- Weekend afternoons at Central/Sacher — tourist crush
- Monday at Sperl (closed in summer)

---

## The Experience

A proper Viennese coffeehouse visit:

1. Enter, say "Grüß Gott"
2. Sit anywhere (unless told otherwise)
3. Wait for waiter (can take time)
4. Order coffee by proper name
5. Water arrives automatically
6. Take newspaper from rack
7. Stay 1-3 hours reading, thinking, watching
8. Ask for bill
9. Tip, leave at your leisure

This is not caffeine consumption. It's a way of life.
