# Video Prompt Guide

## Writing Effective Video Prompts

### Structure

```
[Subject] + [Action/Motion] + [Style] + [Lighting/Atmosphere]
```

### Examples

**Good Prompts:**
- "A cat walking on a beach at sunset, cinematic lighting, slow motion"
- "Cyberpunk city street, neon lights, people walking, rain reflections"
- "A flower blooming in time-lapse, macro shot, soft morning light"

**Bad Prompts:**
- "cat" (too vague)
- "city video" (no motion description)
- "make something cool" (not specific)

## Motion Descriptors

| Effect | Keywords |
|--------|----------|
| **Slow** | slow motion, gradual, smooth, flowing |
| **Fast** | fast-paced, quick, rapid, dynamic |
| **Camera** | zoom in, pan left, dolly shot, drone view |
| **Natural** | flowing, swaying, drifting, falling |
| **Human** | walking, running, dancing, waving |

## Style Keywords

- **Cinematic** - movie-like, dramatic lighting
- **Anime** - animated, cartoon style
- **Realistic** - photorealistic, lifelike
- **Abstract** - artistic, surreal, dreamy
- **Vintage** - retro, old film, VHS effect

## Tips for SVD

1. **Keep it short** - 2-4 seconds works best
2. **One main subject** - Don't overcrowd the scene
3. **Clear motion** - Describe what moves and how
4. **Good lighting** - Mention time of day, light sources

## Tips for AnimateDiff

1. **Longer prompts OK** - Can handle more detail
2. **Character consistency** - Describe appearance clearly
3. **Scene transitions** - Can handle multiple shots
4. **Style locking** - Specify art style early in prompt

## Negative Prompts (What to Avoid)

Add these to reduce artifacts:
- distorted, deformed, blurry
- extra limbs, missing parts
- flickering, unstable
- low quality, watermark

## Prompt Templates

### Nature
```
A [animal] [action] in [location], [time of day], [weather], [style]
```

### Urban
```
[Location] scene, [people/vehicles] [action], [lighting], [atmosphere]
```

### Abstract
```
[Colors] [shapes] moving and transforming, [mood], [style]
```

### Product
```
[Product] rotating/showing features, [background], [lighting], commercial style
```
