# AI Video Promotion & Marketing

Strategies for promoting content created with AI video generation.

---

## Platform-Specific Optimization

### YouTube
- **Thumbnails matter more than video quality** — AI-generated thumbnails often outperform, test multiple
- **First 30 seconds determine retention** — front-load hook, avoid slow intros
- **Optimal lengths:** Shorts (< 60s), standard (8-12 min), long-form (20+ min for watch time)
- **SEO:** Title, description, tags still matter — include keywords naturally
- **Consistency beats virality** — regular uploads build subscriber base faster

### TikTok / Reels / Shorts
- **Vertical 9:16 is mandatory** — don't letterbox horizontal content
- **Hook in first 1-3 seconds** — or users scroll past
- **Trending audio** — even AI video benefits from popular sounds
- **Text overlays** — 80% watch without sound
- **Post timing:** 7-9 AM, 12-3 PM, 7-9 PM local time

### LinkedIn
- **Native upload outperforms links** — 3x more reach
- **Subtitles required** — autoplay is muted
- **Professional context** — behind-the-scenes, explainers, thought leadership
- **Square 1:1 works well** — takes more feed space

### Twitter/X
- **Max 2:20 for organic** — shorter performs better
- **Quote tweet with context** — adds discoverability
- **Thread format** — post video + follow-up commentary

---

## Content Strategy for AI Video

### Types That Perform
- **Explainers** — AI excels at consistent visuals for educational content
- **Product demos** — iterate variations quickly
- **Social proof** — testimonial-style with AI avatars (disclose)
- **Trend participation** — fast turnaround on viral formats
- **Localization** — same video in multiple languages/styles

### Types to Avoid
- **Authenticity-dependent content** — audiences detect AI in personal stories
- **News/journalism** — credibility issues
- **Long-form narrative** — coherence degrades over time
- **Anything pretending to be real footage** — disclosure requirements increasing

---

## Disclosure & Ethics

### Legal Requirements
- **FTC (US):** Synthetic media must be disclosed in advertising
- **EU AI Act:** High-risk AI systems require transparency
- **Platform policies:** TikTok, YouTube, Meta require AI content labels

### Best Practices
- Add "Made with AI" or "AI-generated" in description
- Don't create fake testimonials or fake people endorsements
- Don't generate content of real people without consent
- Watermarks from free tiers often required — factor into production

---

## A/B Testing AI Video

### What to Test
- **Hooks** — generate 5-10 different openings, test which retains
- **CTAs** — different text, timing, visual treatment
- **Thumbnails** — AI generate dozens, test top performers
- **Length** — same content at 30s, 60s, 90s
- **Style** — realistic vs stylized for same message

### Testing Framework
1. Generate variations (AI makes this cheap)
2. Split test with small ad spend ($20-50 per variant)
3. Measure: watch time, CTR, conversion
4. Scale winner with larger budget

### Metrics That Matter
- **Hook rate** — % watching past 3 seconds
- **Retention curve** — where do people drop off
- **CTR** — if driving to landing page
- **Cost per view** — for paid distribution
- **Share rate** — organic amplification

---

## Distribution Channels

### Organic
- **YouTube SEO** — optimize title, description, tags, chapters
- **Social native upload** — always upload directly, never link
- **Email embedding** — GIFs/thumbnails linking to video
- **Blog posts** — embed relevant videos in written content
- **Community posting** — Reddit, Discord, niche forums (add value, don't spam)

### Paid
- **Meta Ads** — video ads 20-30% lower CPA than static
- **YouTube Ads** — skippable in-stream for awareness, shorts for reach
- **TikTok Ads** — native feel required, polished = ignored
- **LinkedIn Ads** — high CPM but targeted B2B
- **Programmatic** — video pre-roll across web

### Amplification
- **Influencer seeding** — provide clips for creators to use
- **PR/earned media** — novel AI use cases get coverage
- **Repurposing** — one long video → shorts, clips, GIFs, stills

---

## Cost-Effective Scaling

### Production Efficiency
- **Batch similar content** — same style, different messages
- **Template approach** — create base, swap elements
- **Preview at low res** — only upscale winners
- **Reuse assets** — generated characters, backgrounds, music

### Budget Allocation
- 60% on winning creative (after testing)
- 30% on testing new variations
- 10% on experimental formats

### ROI Benchmarks
- B2C video ads: aim for 3-5x ROAS
- B2B: longer attribution, track pipeline influence
- Organic: measure against content production cost saved

---

## Common Mistakes

- **Overproducing before testing** — generate cheap, test fast, polish winners
- **Ignoring platform specs** — each platform has optimal formats
- **No clear CTA** — every video needs a next step
- **Inconsistent posting** — algorithms reward regularity
- **Not disclosing AI** — legal/reputational risk growing
- **Focusing on views over conversions** — vanity metrics don't pay bills
- **Using AI for everything** — some content needs human touch

---

## Workflow Example

1. **Ideation** — identify trend/topic with search demand
2. **Script** — write hook, body, CTA (AI can assist)
3. **Generate** — create 3-5 video variations
4. **Preview** — internal review, catch obvious issues
5. **Test** — small paid spend across variations
6. **Analyze** — identify winner by retention + conversion
7. **Scale** — increase budget on winner
8. **Repurpose** — clip into shorts, GIFs, thumbnails
9. **Iterate** — apply learnings to next batch
