---
name: video-dl
description: Download videos from YouTube, Reddit, Twitter/X, TikTok, Instagram, and 1000+ other sites using yt-dlp. Use when user provides a video link and wants to download it.
---

# Video Downloader

Download videos from almost any website using yt-dlp.

## Supported Sites

YouTube, Reddit, Twitter/X, TikTok, Instagram, Vimeo, Facebook, Twitch, and 1000+ others. Full list: https://github.com/yt-dlp/yt-dlp/blob/master/supportedsites.md

## Usage

### Quick Download (best quality)

```bash
{baseDir}/scripts/download.sh "URL"
```

Downloads to `~/Downloads/videos/` with best quality.

### With Options

```bash
{baseDir}/scripts/download.sh "URL" [OPTIONS]
```

**Common options:**
- `--audio-only` - Extract audio only (mp3)
- `--720p` - Limit to 720p max
- `--1080p` - Limit to 1080p max  
- `--output DIR` - Custom output directory
- `--filename NAME` - Custom filename (without extension)

### Examples

```bash
# Download YouTube video (best quality)
{baseDir}/scripts/download.sh "https://www.youtube.com/watch?v=dQw4w9WgXcQ"

# Download Reddit video
{baseDir}/scripts/download.sh "https://www.reddit.com/r/videos/comments/abc123/cool_video/"

# Extract audio only
{baseDir}/scripts/download.sh "https://www.youtube.com/watch?v=dQw4w9WgXcQ" --audio-only

# Download to specific folder
{baseDir}/scripts/download.sh "URL" --output ~/Videos/projects

# Custom filename
{baseDir}/scripts/download.sh "URL" --filename "my-video"
```

## Output

- Default location: `~/Downloads/videos/`
- Filename format: `{title}-{id}.{ext}`
- Returns full path to downloaded file on success

## Notes

- Reddit videos require merging video+audio (handled automatically)
- Age-restricted YouTube videos may require cookies (not currently configured)
- Very long videos may take time; script shows progress
- If download fails, check if the site is supported or if the video is private/deleted

## Sending to Telegram

Large videos need compression for Telegram's 16MB limit. For long videos:

1. Download the video normally
2. Run compression in background:
   ```bash
   nohup {baseDir}/scripts/compress-and-send.sh "/path/to/video.mp4" "CHAT_ID" > /tmp/compress.log 2>&1 &
   ```
3. Check back after estimated time (duration ÷ 4)
4. Send the resulting `-telegram.mp4` file

This avoids spamming the chat with progress updates.

## Direct yt-dlp Access

For advanced usage, yt-dlp is available at `~/.local/bin/yt-dlp` (updated) or `/usr/bin/yt-dlp`. See `yt-dlp --help` for all options.
