# Risk Mitigation — Vibe Research

## Known Risks

### 1. Hallucinations
AI generates plausible but false information.

**Mitigations:**
- Require citations for every factual claim
- Cross-verify critical facts across 3+ sources
- Use retrieval-augmented generation (ground in real docs)
- Flag confidence levels explicitly
- Human validates key findings before publication

### 2. Bias Propagation
AI reflects biases in training data or source material.

**Mitigations:**
- Diversify source types (academic, industry, geographic)
- Explicitly check for representation gaps
- Document source selection criteria
- Human reviews for blind spots

### 3. Loss of Methodological Rigor
Speed prioritized over quality.

**Mitigations:**
- Document every analytical step
- Require reproducibility package with all outputs
- Human validates methodology before execution
- Peer review of AI-generated protocols

### 4. Researcher Skill Erosion
Over-reliance on AI degrades human expertise.

**Mitigations:**
- Keep human engaged in critical thinking
- Require human to articulate reasoning, not just approve
- Use AI as collaborator, not replacement
- Periodic "manual" research exercises

### 5. Academic Integrity
Unclear attribution, plagiarism risks.

**Mitigations:**
- Transparent disclosure of AI involvement
- Clear citation of all sources
- Human takes responsibility for final output
- Follow institutional guidelines on AI use

---

## Quality Checklist

Before finalizing any research output:

```
□ All factual claims have citations
□ Key findings verified across multiple sources
□ Methodology documented for reproducibility
□ Confidence levels flagged appropriately
□ Human has validated critical findings
□ Limitations explicitly stated
□ AI involvement disclosed
□ Source diversity checked
```

---

## When to Escalate to Human

Pause and request human input when:
- Contradictory evidence with no clear resolution
- High-stakes claims that could cause harm if wrong
- Methodology requires domain expertise to validate
- Ethical considerations arise
- Results are unexpected and consequential
