# Vibe Marketing Tools

## Quick Selection Guide

| You need... | Best tool |
|-------------|-----------|
| Content writing | Claude, ChatGPT |
| Social trends + X posts | Grok |
| Simple automations | Zapier |
| Complex workflows | Make, n8n |
| Graphic design | Canva |
| Video generation | HeyGen |
| Brand identity | Looka |
| SEO content | Semrush |

## LLMs for Marketing

### ChatGPT
- **Best for:** General content, brainstorming, versatility
- **Strength:** Huge training data, image generation
- **Weakness:** Can be generic without strong prompting
- **Tip:** Use Custom GPTs for repeatable brand tasks

### Claude
- **Best for:** Long-form content, nuanced writing
- **Strength:** Better at tone matching, less robotic
- **Weakness:** Capacity limits on heavy use
- **Tip:** Use artifacts for iterative editing

### Grok
- **Best for:** Twitter/X content, real-time trends
- **Strength:** Direct X integration, trend awareness
- **Weakness:** Smaller general knowledge base
- **Tip:** Use for social listening and rapid-response content

## Automation Platforms

### Zapier
- **Best for:** Beginners, simple triggers
- **Strength:** 8000+ app integrations
- **Weakness:** Limited branching logic
- **Pricing:** Free tier, paid from $20/mo

### Make
- **Best for:** Visual thinkers, flexible workflows
- **Strength:** Powerful branching, good value
- **Weakness:** Learning curve for complex flows
- **Pricing:** Free tier, paid from $9/mo

### n8n
- **Best for:** Technical teams, privacy-conscious
- **Strength:** Self-hosted option, code-level control
- **Weakness:** Steeper learning curve
- **Pricing:** Free self-hosted, cloud from $20/mo

## Creative Tools

### Canva
- **Best for:** All visual content, non-designers
- **Strength:** Templates, Brand Kits, Magic Resize
- **Tip:** Set up Brand Kit first for consistency

### HeyGen
- **Best for:** Talking head videos without filming
- **Strength:** Realistic avatars, multiple languages
- **Use cases:** Explainer videos, social ads, tutorials

### Looka
- **Best for:** Brand identity from scratch
- **Strength:** AI logo + full brand kit generation
- **When to use:** New brands, rebrands on budget

## Workflow Examples

### Solo Marketer Stack
```
Claude (content) + Canva (design) + Zapier (automation)
Cost: ~$50/mo total
```

### Startup Team Stack
```
ChatGPT Teams + Make + Canva Pro + HeyGen
Cost: ~$150/mo total
```

### Agency/Advanced Stack
```
Multiple LLMs + n8n (self-hosted) + Full creative suite
Cost: Variable, but maximum flexibility
```

## Anti-Pattern: Tool Overload

More tools ≠ better marketing.
- Pick ONE LLM as primary
- Pick ONE automation platform
- Pick ONE design tool
- Add specialty tools only when needed

The goal is flow state, not tool switching.
