# Campaign Testing Framework

## The Vibe Testing Mindset

Traditional: Perfect → Launch → Hope
Vibe Marketing: Good enough → Launch → Learn → Iterate

Speed of learning > perfection of execution.

## 48-Hour Testing Cycles

### Day 1
Morning: Generate 5 variants with AI
Afternoon: Launch 3 best variants
Evening: First data starts coming in

### Day 2
Morning: Analyze early signals
Afternoon: Kill worst performer, double down on best
Evening: Generate next iteration based on learnings

### Day 3+
Repeat. Compound learnings.

## What to Test (Priority Order)

### High Impact
1. **Headlines/Hooks** — 80% of performance lives here
2. **Offers** — What you're promising
3. **Audiences** — Who sees it
4. **CTAs** — What you ask them to do

### Medium Impact
5. **Body copy** — Supporting content
6. **Images/Creative** — Visual elements
7. **Timing** — When it's delivered

### Low Impact (Stop A/B Testing)
- Button colors
- Minor word changes
- Font sizes

## AI-Assisted Variant Generation

```
I'm testing [ad/email/post] for [goal].
Current version: [paste]
Generate 4 variants:
1. Different emotional appeal
2. Different hook structure
3. Shorter/more direct version
4. Contrarian angle
```

## Interpreting Results

### Statistical Significance
- Minimum 100 conversions per variant for confidence
- 95% confidence = you can trust it
- <95% confidence = keep running or call it a tie

### Early Signals (Before Significance)
- CTR patterns after 1000 impressions
- Engagement rate differences >20%
- Clear winner emerging = can act early

### What to Track

| Funnel Stage | Metric |
|--------------|--------|
| Attention | Impressions, Reach |
| Interest | CTR, Engagement Rate |
| Desire | Time on page, Scroll depth |
| Action | Conversion rate, CPA |

## Learning Documentation

After each test:
```
## Test: [Name]
Date: [When]
Hypothesis: [What we thought]
Winner: [What won]
Margin: [By how much]
Learning: [Why we think it won]
Next test: [What this inspires]
```

Keep a "Test Learnings" doc. Over time, patterns emerge.

## Common Testing Mistakes

### Testing Too Many Variables
- Test ONE thing at a time
- Different headline + different image = you learn nothing

### Stopping Too Early
- "We got 10 conversions, B is winning!" ← No significance
- Wait for statistical confidence or time-box + accept uncertainty

### Not Acting on Results
- Test → Learn → Do nothing = waste
- Winner should become new control immediately

### Testing Low-Impact Elements
- Stop testing button colors
- Test your offer, not your font
