# Making AI Content Sound Human

## Red Flags: AI-Sounding Phrases

### Universal Openers (Delete These)
- "In today's fast-paced world..."
- "In the ever-evolving landscape of..."
- "It's no secret that..."
- "Have you ever wondered..."
- "Let me tell you a story..."
- "Picture this:"

### Buzzword Clusters (Replace with Specifics)
- "Game-changer" → What specifically changed?
- "Revolutionary" → How is it different?
- "Cutting-edge" → What edge? Why cutting?
- "Seamless" → Describe the actual experience
- "Unlock your potential" → Potential for what?
- "Take it to the next level" → What level? What changes?

### Hedging Language (Cut or Commit)
- "It's important to note that..."
- "It's worth mentioning..."
- "One could argue that..."
- "It's safe to say..."

Either say it directly or don't say it.

### Over-Structured Lists
AI loves perfect parallelism. Real humans don't always:
- Mix sentence lengths
- Break pattern occasionally
- Use fragments. Like this.
- Vary list item structure

## Humanization Techniques

### Add Imperfection
- Contractions (it's, don't, we're)
- Sentence fragments
- Starting sentences with "And" or "But"
- Conversational asides (in parentheses)

### Inject Specificity
Before: "We saw great results"
After: "We saw a 34% lift in 3 weeks"

Before: "Many customers love it"
After: "Sarah from Notion DM'd us: 'Finally something that works'"

### Add Opinion
AI hedges. Humans commit.
- "This is the best way to..." (not "This could be one approach...")
- "Don't do X" (not "You might want to consider avoiding X")
- "Most advice on this is wrong" (not "There are varying perspectives")

### Include Real Stories
AI can't make these up:
- "Last Tuesday, I got an email from..."
- "When we launched in 2023, we had 12 users..."
- "My co-founder's reaction was..."

## Edit Pass Checklist

After AI draft:
1. [ ] Read aloud — does it sound like you'd say it?
2. [ ] Find 3 generic phrases — replace with specifics
3. [ ] Add one personal detail or real number
4. [ ] Cut opening fluff — start with the point
5. [ ] Check: would you text this to a friend?

## Brand Voice Document

Keep a living doc with:
```
## We Sound Like
- [Example 1 with link]
- [Example 2 with link]

## We Don't Sound Like
- Corporate speak
- Buzzword-heavy marketing
- Overly enthusiastic

## Phrases We Use
- [Your signature phrases]

## Phrases We Avoid
- [Banned words/phrases]
```

Feed this to AI with every content request.
