# Content Generation Patterns

## The Context Stack

Build prompts in layers:

```
[Brand Context]
Company: [name], [what you do]
Audience: [specific persona]
Voice: [3-5 adjectives]
Examples of our voice: [2-3 links or pastes]

[Task Context]
Platform: [where this goes]
Goal: [what success looks like]
Format: [structure requirements]

[Specific Request]
Write: [exactly what you need]
```

## Content Type Patterns

### Social Posts
```
LinkedIn post for [persona].
Topic: [specific insight or story]
Structure: Hook (question or bold claim) + 3 supporting points + CTA
Tone: [adjective], like [example person/brand]
Length: [X] words max
```

### Email Sequences
```
Email [X] of [Y]-email sequence.
Goal of sequence: [nurture/convert/onboard]
This email's job: [specific action]
Previous email covered: [context]
Subject line style: [curiosity/benefit/urgency]
```

### Ad Copy
```
[Platform] ad for [audience].
Product: [what it does, core benefit]
Offer: [what they get]
Objection to overcome: [main hesitation]
Variations: Generate 3 with different hooks
```

### Blog/Long-form
```
Blog post outline for: [topic]
Target keyword: [if SEO]
Reader's current belief: [what they think now]
Reader's desired belief: [what we want them to think]
Unique angle: [why OUR take is different]
```

## Iteration Prompts

After first draft:
- "Make it shorter and punchier"
- "Remove any clichés or generic phrases"
- "Add a specific example or data point to paragraph 2"
- "Rewrite the hook with more tension"
- "Make it sound less like a marketer, more like a friend texting"

## Batch Generation

For content calendars:
```
Generate 10 LinkedIn post ideas for [topic cluster].
For each: one-line hook + 2-sentence expansion.
Mix: 3 contrarian takes, 3 how-tos, 2 personal stories, 2 observations.
```

Then select best 5 and expand individually.
