---
name: Vibe Marketing
slug: vibe-marketing
version: 1.0.0
description: Run marketing campaigns with AI automation. Covers content generation, workflow automation, copy that sounds human, and rapid testing.
metadata: {"clawdbot":{"emoji":"📣","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## What is Vibe Marketing

Marketing where you describe what you want and let AI generate content, copy, and campaigns. You iterate based on results rather than crafting every word manually. Inspired by vibe coding — same philosophy applied to marketing.

**Core principle:** Eliminate friction to achieve flow state. 80% time on creative direction, 20% on operations.

## Quick Reference

| Topic | File |
|-------|------|
| Content generation patterns | `content.md` |
| Workflow automation | `automation.md` |
| Copy that sounds human | `humanize.md` |
| Campaign testing framework | `testing.md` |
| Tools by use case | `tools.md` |

## Core Rules

### 1. Prompt with Brand Context
Generic prompts → generic output. Always include:
- Target audience (specific, not "everyone")
- Brand voice (3-5 adjectives or examples)
- Goal of the piece (awareness, conversion, engagement)
- Format constraints (length, platform, style)

Bad: "Write a LinkedIn post about our product"
Good: "LinkedIn post for B2B SaaS founders. Voice: direct, no fluff, slightly provocative. Goal: drive demo signups. Hook + 3 bullets + CTA. Under 200 words."

### 2. Show, Don't Describe Tone
Instead of saying "write in a friendly tone":
- Provide 2-3 examples of content you like
- Reference specific posts/ads that match desired vibe
- Give a "sounds like X, not like Y" comparison

### 3. Layer Human Elements
AI struggles with:
- Specific personal anecdotes
- Controversial or edgy takes
- Cultural references that resonate NOW
- Imperfect, authentic language

Always add: real stories, specific numbers from YOUR data, opinions only YOU can have.

### 4. Rapid Testing Over Perfection
Vibe marketing = speed + iteration. Launch fast, measure, adjust.
- Generate 5 variants, test 3, kill 2
- 48-hour feedback loops, not 2-week campaigns
- Use AI to generate A/B variants, not "final" copy

### 5. Automation with Checkpoints
Automate repetitive tasks but keep human approval on:
- Brand voice changes
- Controversial topics
- High-spend ad campaigns
- Customer-facing messaging

See `automation.md` for workflow patterns.

### 6. Detect AI-Sounding Copy
Red flags to edit out:
- "In today's fast-paced world..."
- "Let's dive in" / "Let's explore"
- "Game-changer" / "Revolutionary" / "Cutting-edge"
- Perfect parallel structure in every sentence
- Generic benefits without specifics
- Hedging language ("It's important to note...")

See `humanize.md` for fix patterns.

### 7. Platform-Native Content
Each platform has different vibes. Don't cross-post identical content:
- LinkedIn: Professional insight, personal story, contrarian take
- Twitter/X: Punchy, thread-friendly, engagement hooks
- Instagram: Visual-first, caption supports image
- Email: Personal, direct, one clear CTA

### 8. Compound Your Brand Knowledge
Create a "brand brief" document that grows:
- Voice examples that worked
- Phrases to avoid
- Audience insights from campaigns
- Winning hooks and CTAs

Feed this to AI in every session. Your competitive advantage = accumulated brand context.

### 9. When NOT to Vibe Market
- Crisis communications
- Legal/compliance-heavy content
- Deeply personal brand storytelling
- Sensitive customer issues

These need human judgment, not AI speed.
