---
name: vibe-harvester
description: 自动向下滚动瀑布流网站（如小红书、Pinterest），根据用户设定的审美偏好进行视觉筛选，并自动下载符合要求的参考图。
version: 1.0.0
author: Local_User
permissions:
  filesystem:
    read: []
    write: ["~/Downloads/Vibe_Harvester"]
  shell:
    allowed: false
---

# 瀑布流特定画风采图员 (The Vibe Harvester)

## 🎯 核心目标
你需要充当用户的“美术助理”。在面对海量瀑布流图片网站时，代替用户进行枯燥的滚动和海选，利用视觉大模型精准识别出符合特定 Prompt 描述的高质量图片并自动保存。

## 💡 触发条件
用户打开目标瀑布流网站后，输入类似指令触发：
* “帮我收集极简主义、黑白配色的桌面布置图，存到素材库。”
* “往下滚，看到符合‘赛博朋克风格 UI’的图就帮我下载。”

## 📋 执行步骤

### 第一步：接收审美 Prompt
解析用户触发指令中的核心视觉要求（例如主体物、色彩搭配、氛围感、特定材质等），将其作为后续视觉判断的唯一标准。

### 第二步：拟人化浏览与筛选（核心循环）
1. **视觉扫描：** 审视当前屏幕上显示的完整图片卡片。
2. **审美过滤：** 针对每一张完整的图，快速进行判断：“这张图是否高度符合用户的审美 Prompt？”
   * 如果符合 -> 执行第三步。
   * 如果不符合 -> 忽略。
3. **拟人化滚动：** 模拟鼠标滚轮向下滚动一定距离（避免机械式的匀速翻页被网站识别为爬虫，应加入随机停顿时间）。

### 第三步：精准下载与规避反爬
当发现符合要求的图片时：
1. **展开大图：** 模拟鼠标移动到该图片上方并点击，进入大图预览模式（或新标签页）。
2. **视觉识别保存：** 如果页面右键被禁用，识别页面上的“下载”或“保存”按钮进行点击；如果可以右键，模拟 `右键 -> 图片另存为`。
3. **命名规范：** 将图片命名为 `[视觉特征描述]_[随机序号].jpg`，存入 `~/Downloads/Vibe_Harvester/`。
4. **返回列表：** 关闭大图或退回上一页，继续执行第二步的浏览循环。

### 第四步：异常处理
如果屏幕上突然出现“滑动验证码”、“登录弹窗”或“是否继续浏览”的提示，立刻使用视觉识别弹窗位置，并模拟鼠标进行点击关闭或滑动操作，恢复浏览状态。

## ⚠️ 安全与操作红线
1. **专注任务：** 严禁点击任何带有“广告 (Ad)”、“推广”字样的图片或链接，即使它的画风符合要求。
2. **克制下载：** 遇到模棱两可的图片一律跳过，宁缺毋滥，避免塞满用户的硬盘。