# Vibe Design Tools

## Quick Selection Guide

| You need... | Best tool |
|-------------|-----------|
| UI mockups and prototypes | Figma AI |
| Artistic concept exploration | Midjourney |
| Quick image edits | DALL-E / GPT-4 |
| Open-source control | Stable Diffusion |
| Marketing visuals | Canva Magic Studio |
| Video content | Runway, HeyGen |
| Brand identity | Looka |

## Image Generation

### Midjourney
- **Best for:** Artistic concepts, mood boards, visual exploration
- **Strength:** High aesthetic quality, style control
- **Weakness:** Runs through Discord, learning curve
- **UI tip:** Use --style raw and design vocabulary
- **Pricing:** $10-60/month

### DALL-E 3 / GPT-4
- **Best for:** Quick iterations, image editing
- **Strength:** Natural language, integrated in ChatGPT
- **Weakness:** Less stylistic control
- **Pricing:** Included in ChatGPT Plus ($20/mo)

### Stable Diffusion
- **Best for:** Custom models, open-source needs
- **Strength:** Free, trainable, full control
- **Weakness:** Technical setup, quality varies
- **Use via:** ComfyUI, Automatic1111, or DreamStudio

### Adobe Firefly
- **Best for:** Enterprise, brand safety
- **Strength:** Adobe ecosystem, content credentials
- **Weakness:** More conservative output
- **Pricing:** Included in Creative Cloud

## UI/UX Tools

### Figma
- **Best for:** Production UI design, prototyping
- **AI features:** Image generation, background removal, auto-naming
- **Strength:** Industry standard, collaborative
- **Pricing:** Free tier, $15+/mo for teams

### Uizard
- **Best for:** Sketch-to-UI, rapid prototyping
- **Strength:** Hand-drawn → digital conversion
- **Weakness:** Output needs refinement
- **Pricing:** Free tier, $12+/mo

## Marketing/Creative

### Canva Magic Studio
- **Best for:** Social media, marketing assets
- **Strength:** Templates, brand kits, easy
- **Weakness:** Less control for custom work
- **Pricing:** Free tier, $13+/mo

### Runway
- **Best for:** Video editing, motion graphics
- **Strength:** Gen-2 video, inpainting, motion brush
- **Pricing:** Free tier, $15+/mo

### HeyGen
- **Best for:** Talking head videos, avatars
- **Strength:** Realistic AI presenters
- **Pricing:** Free tier, $29+/mo

## Workflow Stacks

### Solo Designer
```
Midjourney (explore) + Figma (build) + Canva (assets)
Cost: ~$50/mo
```

### Design Team
```
Figma Team + Midjourney + Adobe CC
Cost: ~$100+/mo per seat
```

### Non-Designer
```
Canva Magic Studio + DALL-E
Cost: ~$30/mo
```

## Integration Tips

### Midjourney → Figma
1. Generate concepts in Midjourney
2. Download selected images
3. Import as reference layer in Figma
4. Rebuild using your design system
5. Delete reference when done

### AI → Production Checklist
- [ ] Extracted color palette
- [ ] Noted spacing relationships
- [ ] Identified typography direction
- [ ] Listed component ideas
- [ ] Documented mood/feeling
- [ ] Rebuilt with real tokens
- [ ] Replaced placeholder content
- [ ] Tested responsive behavior
