---
name: Vibe Coding
slug: vibe-coding
version: 1.0.0
description: Build software with AI by describing what you want. Covers prompting techniques, workflow patterns, rules files, and when to intervene.
metadata: {"clawdbot":{"emoji":"🎸","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## What is Vibe Coding

Programming where you describe what you want and let AI generate code. You evaluate by results, not by reading every line. Coined by Andrej Karpathy (Feb 2025).

**Key distinction (Simon Willison):** If you review, test, and can explain the code — that's software development, not vibe coding. Vibe coding means accepting AI output without fully understanding every function.

## Quick Reference

| Topic | File |
|-------|------|
| Prompting techniques | `prompting.md` |
| Research-Plan-Implement workflow | `workflow.md` |
| Rules files (.cursorrules, CLAUDE.md) | `rules-files.md` |
| Common pitfalls and fixes | `pitfalls.md` |
| Tool selection by use case | `tools.md` |

## Core Rules

### 1. Define Intent Before Prompting
Vague prompts → vague results. Before touching your AI tool:
- What specific problem are you solving?
- What does "done" look like?
- What are the constraints (stack, integrations, flow)?

Bad: "Build a social media app"
Good: "Build a social feed: text posts (280 chars), follow users, chronological feed, likes/comments. Use React, Tailwind, Supabase."

### 2. Use Rules Files
Persistent context that teaches AI your conventions. Put it in once, applies to every interaction:
- Cursor: .cursorrules or .cursor/rules/
- Claude Code: CLAUDE.md
- Windsurf: .windsurfrules

See `rules-files.md` for templates.

### 3. Research-Plan-Implement
Before implementing, have AI explore and plan:
1. **Research**: "Read the auth module, explain how sessions work"
2. **Plan**: "Write the files you'll modify and changes in each"
3. **Implement**: Only after reviewing the plan

Catching misunderstanding during planning = 10x cheaper than debugging cascading errors.

### 4. When to Intervene vs Let It Flow
- **Let it flow**: Scaffolding, UI components, exploring ideas
- **Intervene**: Auth, payments, data handling, anything security-adjacent
- **Always review**: Database schemas, API permissions, user data handling

### 5. Test After Every Change
AI generates code that looks flawless but has subtle bugs. After every change:
- Run test suite
- Manually test the affected feature
- Check console for errors
- Verify happy path AND edge cases

### 6. Paste Errors, Let AI Fix
The Karpathy move: copy error message, paste with no comment, usually it fixes it. If AI can't fix after 2-3 attempts, describe the behavior you want instead.

### 7. Constraint Anchoring
Set explicit boundaries:
- Length: "Under 50 lines of code"
- Format: "Only the modified function, not entire file"
- Scope: "Only payment flow, don't touch auth"
- Style: "Follow existing pattern in UserService.ts"

### 8. Know When Vibe Coding is Appropriate
**Good for**: Prototypes, MVPs, internal tools, weekend projects, UI components, boilerplate, learning
**Bad for**: Security-critical code, performance-critical code, compliance-heavy domains, long-term production systems

### 9. Experienced Developers + Vibe Coding = Superpowers
The best vibe coders understand architecture, spot bad AI output, and know when to intervene. If you can't evaluate whether AI produced good code, you need to learn more before vibe coding production systems.
