# The Bottleneck Framework

## Reframing the Bottleneck

Traditional view: "Being the bottleneck is bad. Eliminate it."
Vibe clawing view: "Being the bottleneck means you solved the level below. Time to climb."

The bottleneck isn't a problem to fix — it's a signal you've progressed.

---

## The Ladder

```
Level 5: Setting vision       ← Bottleneck here = you've automated operations
Level 4: Strategic decisions  ← Bottleneck here = you've automated workflows
Level 3: Process oversight    ← Bottleneck here = you've automated tasks
Level 2: Task review          ← Bottleneck here = AI does the work
Level 1: Manual execution     ← Starting point
```

Each time you reach a bottleneck, you've conquered the level below.
The goal isn't to never be a bottleneck — it's to be a bottleneck at higher levels.

---

## Bottleneck Signals by Level

### Level 1 → 2: "I'm doing everything manually"
- Action: Start delegating individual tasks
- Sign of progress: Agent does work, you review

### Level 2 → 3: "I'm just approving task outputs"
- Action: Let agent handle sequences without per-task approval
- Sign of progress: You review outcomes, not steps

### Level 3 → 4: "I'm just validating workflows"
- Action: Define success criteria, let agent run workflows end-to-end
- Sign of progress: You only intervene on exceptions

### Level 4 → 5: "I'm just making strategic decisions"
- Action: Set direction, let agent handle strategy execution
- Sign of progress: You define "what should exist", agent figures out how

### Level 5: "I'm only setting vision"
- This is the goal. You point at what matters. Everything else runs.

---

## How to Climb

1. **Recognize the bottleneck**
   Notice where everything waits for you.

2. **Ask why**
   Is it because you must? Or because you haven't let go?

3. **Define the criteria**
   What would make you comfortable not being involved?

4. **Release with guardrails**
   Escalation paths, monitoring, audit intervals.

5. **Climb up**
   Now you're bottleneck at the next level. Repeat.

---

## Common Traps

### "But I need to verify everything"
If you've verified 100 times and it was fine 98 times, you're burning your attention.
Define what the 2 bad cases looked like. Escalate on those patterns. Release the rest.

### "Nobody can do this but me"
Maybe true for now. But is it because of skill or knowledge?
If knowledge → document and transfer.
If skill → find the 80% that's teachable, keep the 20% edge cases.

### "What if it goes wrong?"
It will, sometimes. The question: Are failures recoverable?
If yes → let it fail, learn, improve.
If no → stay in the loop for that specific type.

### "I'll lose control"
You're gaining leverage, not losing control.
Control over outcomes (good) vs. control over process (inefficient).

---

## Tracking Your Level

In your profile, track:
- Current primary bottleneck level
- What you've released from each level
- What's blocking the next climb

Regular audit: Am I bottleneck at a level I've already solved?
If yes → time to release and climb.
