---
name: Vibe Clawing
description: Transition from vibe coding to vibe clawing by trusting agents with full responsibilities, designing self-closing loops, and climbing the bottleneck ladder.
version: 1.0.1
changelog: "Preferences now persist across skill updates"
---

## Core Principle

Vibe coding = trusting AI with tasks, staying in the loop.
Vibe clawing = trusting AI with responsibilities, stepping out of the loop.

The shift: Stop asking "how do I do this?" Start asking "how do I make sure this happens without me?"

---

## The Evolution Path

| Stage | You Do | AI Does | Your Role |
|-------|--------|---------|-----------|
| Manual | Everything | Nothing | Executor |
| Vibe Coding | Decide, review | Single tasks | In the loop |
| Early Clawing | Validate results | Workflows | Closing loops |
| Full Clawing | Set direction | Full systems | Out of the loop |

---

## Quick Reference

| Situation | Load |
|-----------|------|
| Identifying loops to automate | `loops.md` |
| Understanding bottleneck progression | `bottleneck.md` |
| Finding where value moves | `direction.md` |
| Full transition framework | `evolution.md` |

---

## The Bottleneck Signal

When you find yourself just typing "yes", "approved", "continue":
- That's not a problem — it's progress
- You solved the level below
- Time to climb to the next level

Every time you become the bottleneck = you're ready to let go again.

---

## User Profile

Track your vibe clawing journey in `~/vibe-clawing/memory.md`. Create on first use:

```markdown
## Current Stage
<!-- manual | vibe-coding | early-clawing | full-clawing -->

## Loops Closed
<!-- Responsibilities delegated. Format: "area: status" -->
<!-- Examples: Code reviews: agent 90%, Research: fully automated -->

## Active Bottlenecks
<!-- Where you're the decision point -->
<!-- Examples: Final UI approval, Architecture decisions -->

## Next to Delegate
<!-- What you're working on releasing next -->
```

*Fill as you progress. The goal: more loops closed, fewer bottlenecks.*

---

## Core Behaviors

1. **Audit loops** — Identify where you're still manually closing
2. **Test release** — Let one loop run without you, observe
3. **Connect dots** — Link loops together into larger systems
4. **Climb up** — When you're just approving, you're ready to let go

---

## The Paradox

The more you step back, the faster it grows.
You're not being replaced. You're riding something bigger.
