# VHS Tape File Syntax Reference

## File Structure
1. Output Declaration → 2. Settings → 3. Requirements → 4. Hidden Setup → 5. Commands → 6. Hidden Cleanup

## Command Reference

| Command | Syntax | Description |
|---------|--------|-------------|
| `Output` | `Output file.gif` | Declare output (gif/mp4/webm/frames/) |
| `Type` | `Type "text"` | Type text at global TypingSpeed |
| `Type@` | `Type@500ms "text"` | Type with custom speed |
| `Enter` | `Enter` | Press Enter |
| `Wait` | `Wait` | Wait for shell prompt |
| `Wait` | `Wait /pattern/` | Wait for output text |
| `Wait+Screen` | `Wait+Screen /pat/` | Wait for text anywhere on screen |
| `Wait@` | `Wait@5s /pattern/` | Wait with custom timeout |
| `Sleep` | `Sleep 2s` | Fixed pause |
| `Up/Down` | `Up 2`, `Down 1` | Arrow navigation |
| `Left/Right` | `Left 5`, `Right 3` | Arrow navigation |
| `Backspace` | `Backspace 10` | Delete characters |
| `Tab/Space` | `Tab 2`, `Space 3` | Tab/space keys |
| `PageUp/Down` | `PageUp` | Page navigation |
| `Ctrl+` | `Ctrl+C`, `Ctrl+D` | Control key combos |
| `Copy` | `Copy "text"` | Copy to clipboard |
| `Paste` | `Paste` | Paste from clipboard |
| `Hide` | `Hide` | Stop recording (setup/cleanup) |
| `Show` | `Show` | Resume recording |
| `Require` | `Require git` | Fail-fast dependency check |
| `Env` | `Env VAR "value"` | Set environment variable |
| `Screenshot` | `Screenshot file.png` | Capture frame |
| `Set` | `Set Width 1200` | Configure setting |

## Wait Strategy Selection
- `Wait` (no args) - Shell prompt returns
- `Wait /pattern/` - Text in last command output
- `Wait+Screen /pattern/` - Text anywhere on screen
- `Sleep <duration>` - Known fixed delays

## Hidden Sections
Use `Hide`/`Show` for: installing deps, cloning repos, building, creating test files, clearing terminal.

## Multi-Stage Pattern
```tape
# Stage 1: Problem
Type "git status" → Enter → Wait → Sleep 2s
# Stage 2: Fix
Type "git add ." → Enter → Type "git commit -m 'fix'" → Enter → Wait
# Stage 3: Verify
Type "git status" → Enter → Wait → Sleep 3s
```
