# VHS Timing Control Reference

## 3-2-1 Timing Rule

| Situation | Timing |
|-----------|--------|
| After commands | `Sleep 3s` or `Wait` |
| Between actions | `Sleep 2s` |
| Quick pause | `Sleep 1s` |
| Dramatic pause | `Sleep 5s` |

## TypingSpeed

| Speed | Use Case |
|-------|----------|
| `50ms` | Natural, readable (default) |
| `100ms` | Slow tutorial/teaching |
| `25ms` | Fast, experienced user |
| `10ms` | Instant (hidden setup) |

Per-command override: `Type@500ms "emphasis"`, `Type@10ms "boilerplate"`

## Wait vs Sleep

| Type | When to Use |
|------|-------------|
| `Wait` | Variable command duration, sync with output |
| `Wait /pattern/` | Specific text in command output |
| `Wait+Screen /pat/` | Text anywhere on screen |
| `Wait@30s /pattern/` | Custom timeout (default 15s) |
| `Sleep 2s` | Fixed delays, reading time, dramatic effect |

## Core Patterns

**Command-Wait-Pause** (most common):
```tape
Type "command" → Enter → Wait → Sleep 2s
```

**Quick Succession**:
```tape
Type "git add ." → Enter → Wait → Sleep 500ms
Type "git commit -m 'msg'" → Enter → Wait → Sleep 500ms
```

**Fast Hidden Setup**:
```tape
Hide → Type@10ms "setup commands" → Enter → Sleep 500ms → Show
```

## PlaybackSpeed & Framerate

| Setting | Values | Use |
|---------|--------|-----|
| `PlaybackSpeed` | 0.5 (slow), 1.0 (normal), 2.0 (fast) | Final video speed |
| `Framerate` | 24 (small), 30 (standard), 60 (smooth) | Output FPS |

## Anti-Patterns

- **Wrong**: `Type "npm install" → Enter → Type "npm start"` (no wait!)
- **Right**: `Type "npm install" → Enter → Wait /added/ → Sleep 1s → Type "npm start"`
- **Wrong**: Inconsistent pauses (0s, 5s, 0s, 2s)
- **Right**: Consistent rhythm (2s after each command)
