# VHS Settings Reference

**Critical**: Configure ALL settings BEFORE any commands. Settings cannot change mid-recording.

## Dimension Presets

| Use Case | Width | Height | FontSize | Padding |
|----------|-------|--------|----------|---------|
| README hero | 1200 | 600 | 32-46 | 40 |
| Tutorial | 1400 | 800 | 24-28 | 30 |
| Social media | 1920 | 1080 | 46-52 | 60 |
| Compact | 800 | 500 | 20-24 | 20 |

## All Settings

| Setting | Default | Description |
|---------|---------|-------------|
| `Width` | 1200 | Terminal width (px) |
| `Height` | 600 | Terminal height (px) |
| `FontSize` | 32 | Text size (px) |
| `FontFamily` | "JetBrains Mono" | Font (must be installed) |
| `LetterSpacing` | 1 | Character spacing |
| `LineHeight` | 1.4 | Line spacing |
| `Theme` | "Catppuccin Mocha" | Color theme |
| `Padding` | 40 | Border padding (px) |
| `BorderRadius` | 8 | Corner rounding (px) |
| `WindowBar` | Colorful | Window decoration |
| `TypingSpeed` | 50ms | Default typing speed |
| `Framerate` | 60 | Output FPS |
| `PlaybackSpeed` | 1.0 | Playback multiplier |

## Themes
Popular: `Catppuccin Mocha`, `Dracula`, `GitHub Dark`, `Nord`, `Tokyo Night`, `Gruvbox Dark`
List all: `vhs themes`

## WindowBar Options
`Colorful` (macOS-style), `Rings`, `RingsRight`, `None`

## Fonts
Popular: `JetBrains Mono`, `Fira Code`, `Monaco`, `Menlo`, `Source Code Pro`, `Cascadia Code`
Check installed: `fc-list | grep -i "fontname"`

## Configuration Order
```tape
Output demo.gif          # 1. Outputs
Set Width 1200           # 2. Settings
Set Theme "Dracula"
Require git              # 3. Requirements
Type "echo 'Hello'"      # 4. Commands
```

## Quick Test
Use ASCII for fast iteration:
```tape
Output test.ascii
# ... settings and commands
```
Run: `vhs test.tape && cat test.ascii`
