# VHS Recording Examples

## README Hero Demo
```tape
Output demo.gif
Set Width 1200
Set Height 600
Set FontSize 36
Set Theme "Catppuccin Mocha"
Hide
Type "clear" → Enter
Show
Type "npx create-app my-app" → Enter → Wait /Success/ → Sleep 2s
Type "cd my-app && npm start" → Enter → Wait /Started/ → Sleep 3s
```

## CLI Tool Demo (with hidden setup/cleanup)
```tape
Output demo.gif
Require git
Require node
Hide
Type "cd /tmp && git clone repo && cd repo && clear" → Enter → Sleep 3s
Show
Type "ls -la" → Enter → Wait → Sleep 2s
Type "npm install" → Enter → Wait /added/ → Sleep 2s
Type "npm run demo" → Enter → Wait /Complete/ → Sleep 3s
Hide
Type "cd /tmp && rm -rf repo" → Enter
Show
```

## Docker Workflow
```tape
Output docker.gif
Set Theme "Dracula"
Require docker
Type "docker build -t app ." → Enter → Wait /built/ → Sleep 2s
Type "docker run -d -p 8080:8080 app" → Enter → Wait → Sleep 1s
Type "docker ps" → Enter → Wait → Sleep 2s
Hide
Type "docker stop $(docker ps -q)" → Enter
Show
```

## Git Tutorial (slow typing)
```tape
Output git-tutorial.mp4
Set TypingSpeed 100ms
Type "git init" → Enter → Wait → Sleep 2s
Type "echo '# README' > README.md" → Enter → Sleep 1s
Type "git add ." → Enter → Sleep 1s
Type "git commit -m 'Initial'" → Enter → Wait → Sleep 2s
Type "git log --oneline" → Enter → Wait → Sleep 3s
```

## Error Recovery (dramatic pause + backspace)
```tape
Type "rm -rf production-db/"
Sleep 3s
Backspace 100
Type "rm -rf test-db/" → Enter → Sleep 2s
Type "# Phew!" → Enter → Sleep 2s
```

## Common Patterns

**Clean start**: `Hide → Type "clear" → Enter → Show`

**Command sequence**:
```tape
Type "cmd" → Enter → Wait → Sleep 2s
```

**Quick git flow**:
```tape
Type "git add ." → Enter → Wait → Sleep 500ms
Type "git commit -m 'msg'" → Enter → Wait → Sleep 500ms
Type "git push" → Enter → Wait → Sleep 1s
```

**Screenshot capture**: `Type "cmd" → Enter → Wait → Screenshot shot.png → Sleep 2s`

**Before/After comparison**:
```tape
Type "# Before (slow)" → Enter
Type "time node slow.js" → Enter → Wait → Sleep 3s
Type "# After (fast)" → Enter
Type "time node fast.js" → Enter → Wait → Sleep 3s
```
