---
name: vhs-recorder
description: Create professional terminal recordings with VHS tape files - guides through syntax, timing, settings, and best practices
---

# VHS Recorder

Create terminal recordings with Charm's VHS. Use when creating CLI demos, README animations, documentation videos.

## Prerequisites
- `vhs` installed (`brew install vhs` / `go install github.com/charmbracelet/vhs@latest`)
- `ttyd` and `ffmpeg` on PATH

## Tape File Structure
```tape
Output demo.gif         # Outputs first
Set Width 1200          # Settings second
Set Theme "Catppuccin Mocha"
Require git             # Requirements third
Hide                    # Hidden setup
Type "cd /tmp && clear"
Enter
Show
Type "your command"     # Main recording
Enter
Wait
Sleep 2s
```

## Core Commands
| Command | Purpose |
|---------|---------|
| `Type "text"` | Type text (uses TypingSpeed setting) |
| `Enter` / `Tab` / `Space` | Key presses |
| `Up` / `Down` / `Left` / `Right` | Arrow navigation |
| `PageUp` / `PageDown` | Page navigation |
| `Ctrl+C` / `Ctrl+D` / `Ctrl+L` | Signal/EOF/clear combos |
| `Wait` / `Wait /pattern/` | Wait for prompt or regex match |
| `Sleep 2s` | Fixed pause (supports ms/s/m) |
| `Hide`/`Show` | Hide setup/cleanup from output |
| `Type@50ms "text"` | Override typing speed inline |
| `Backspace N` / `Delete N` | Delete N chars back/forward |
| `Copy` / `Paste` | Clipboard operations |
| `Screenshot path.png` | Capture single frame |
| `Env VAR "value"` | Set environment variable |

## Essential Settings
| Setting | Default | Notes |
|---------|---------|-------|
| Width/Height | 1200/600 | Terminal dimensions in pixels |
| FontSize | 32 | Text size; FontFamily for custom fonts |
| TypingSpeed | 50ms | Per-char delay (override with `Type@Xms`) |
| Theme | - | Use `vhs themes` to list all available |
| Padding | 40 | Border space; LetterSpacing/LineHeight also available |

## Timing & Patterns
**3-2-1 Rule**: 3s after important commands, 2s between actions, 1s for transitions
- **Clean start**: `Hide` → `Type "clear"` → `Enter` → `Show`
- **Command-wait**: `Type` → `Enter` → `Wait` → `Sleep 2s`
- **Fast hidden**: `Type@10ms "setup command"`
- **ASCII preview**: `Output demo.ascii` for instant test

## Output Formats
| Format | Use Case |
|--------|----------|
| `.gif` | Web/README (universal) |
| `.mp4`/`.webm` | Social media / modern browsers |
| `.ascii` | Preview/test (instant, no ffmpeg) |
| `frames/` | PNG sequence for post-processing |

## Quick Fixes
| Issue | Solution |
|-------|----------|
| Commands too fast | Add `Wait` + `Sleep 2s` after Enter |
| Messy terminal | `Hide` → `clear` → `Show` at start |
| Inconsistent pacing | Follow 3-2-1 timing rule |

## CLI Commands
```bash
vhs demo.tape       # Run tape file
vhs themes          # List all available themes
vhs manual          # Show full command reference
```

## References
- [vhs-syntax.md](./references/vhs-syntax.md) - Full command reference
- [timing-control.md](./references/timing-control.md) - Pacing strategies
- [settings.md](./references/settings.md) - All configuration options
- [examples.md](./references/examples.md) - Real-world tape files
