# Vestaboard Character Codes

Source: https://docs.vestaboard.com/docs/characterCodes/

Vestaboard encodes every flap as an integer character code. You can POST a full `layout` (array of arrays of codes) to the Cloud API, or use `text` for simple messages.

| Preview | Name | Code | Notes |
|---:|---|---:|---|
| (blank) | Blank | 0 | Black-on-black Vestaboard / white-on-white Vestaboard |
| A | A | 1 |  |
| B | B | 2 |  |
| C | C | 3 |  |
| D | D | 4 |  |
| E | E | 5 |  |
| F | F | 6 |  |
| G | G | 7 |  |
| H | H | 8 |  |
| I | I | 9 |  |
| J | J | 10 |  |
| K | K | 11 |  |
| L | L | 12 |  |
| M | M | 13 |  |
| N | N | 14 |  |
| O | O | 15 |  |
| P | P | 16 |  |
| Q | Q | 17 |  |
| R | R | 18 |  |
| S | S | 19 |  |
| T | T | 20 |  |
| U | U | 21 |  |
| V | V | 22 |  |
| W | W | 23 |  |
| X | X | 24 |  |
| Y | Y | 25 |  |
| Z | Z | 26 |  |
| 1 | One | 27 |  |
| 2 | Two | 28 |  |
| 3 | Three | 29 |  |
| 4 | Four | 30 |  |
| 5 | Five | 31 |  |
| 6 | Six | 32 |  |
| 7 | Seven | 33 |  |
| 8 | Eight | 34 |  |
| 9 | Nine | 35 |  |
| 0 | Zero | 36 |  |
| ! | Exclamation Mark | 37 |  |
| @ | At | 38 |  |
| # | Pound | 39 |  |
| $ | Dollar | 40 |  |
| ( | Left Parenthesis | 41 |  |
| ) | Right Parenthesis | 42 |  |
| - | Hyphen | 44 |  |
| + | Plus | 46 |  |
| & | Ampersand | 47 |  |
| = | Equal | 48 |  |
| ; | Semicolon | 49 |  |
| : | Colon | 50 |  |
| ' | Single Quote | 52 |  |
| " | Double Quote | 53 |  |
| % | Percent | 54 |  |
| , | Comma | 55 |  |
| . | Period | 56 |  |
| / | Slash | 59 |  |
| ? | Question Mark | 60 |  |
| ° | Degree | 62 | Vestaboard Flagship only |
| ♥ | Heart | 62 | Vestaboard Note only |
| (red) | Red | 63 |  |
| (orange) | Orange | 64 |  |
| (yellow) | Yellow | 65 |  |
| (green) | Green | 66 |  |
| (blue) | Blue | 67 |  |
| (violet) | Violet | 68 |  |
| (white) | White | 69 | For the Local API this is black on a white Vestaboard |
| (black) | Black | 70 | For the Local API this is white on a white Vestaboard |
| (filled) | Filled | 71 | White-on-black / black-on-white; not available for the Local API |
