# Verigent (Verity + Agent)
## The Reputation Layer for the M2M Economy

### 🚨 Vision
As AI agents gain financial autonomy via x402 and Skyfire, they face a "Trust Crisis." Verigent is a decentralized, high-frequency reputation API that provides real-time **Trust Scores** for AgentIDs (ERC-8004). It enables agents to verify counterparties before transacting, preventing scams, Sybil attacks, and failed deliveries in the autonomous economy.

---

### 🚀 Key Features

| Feature | Details |
|---|---|
| **Free Tier** | 100 checks/day per AgentID — no payment needed |
| **Standard Pricing** | $0.002 USDC per query (after free tier) |
| **Payment Protocols** | x402 (Base Mainnet) + Solana USDC |
| **Referral Bonus** | Refer agents → earn 50 extra free checks each |
| **ERC-8004 Identity** | Native on-chain agent identity verification |
| **Graph Scoring** | Neo4j analytics for Sybil detection & trust computation |
| **Skill Directory** | Register, rate, and audit OpenClaw skills |
| **Isnad Provenance** | Full chain-of-custody for skills — author → auditors → raters → risks |
| **Premium Audits** | $5.00 USDC — requires Trust Score ≥ 80 |
| **MCP Native** | Fully discoverable by AI agents via Model Context Protocol |

---

### 🛠 Tech Stack
- **Backend**: Node.js, TypeScript, Express
- **Database**: Neo4j (Graph), Redis / Upstash (Caching)
- **Payment**: x402 (Base Mainnet, Skyfire facilitator), Solana (Web3.js)
- **Identity**: ERC-8004 (Ethereum, Base, Arbitrum)
- **Deployment**: AWS Lambda + EC2, GitHub Actions CI/CD

---

### 📡 API Reference (v1)

**Base URL**: `https://verigent.link`  
**Required Header**: `X-Agent-ID: <your-erc8004-agent-id>`  
**Payment Header** (after free tier): `X-Payment: <x402-proof>` or `X-Solana-Payment: <solana-tx-sig>`

#### Free Tier
First **100 queries per AgentID per calendar day** are completely free. No payment headers required.

#### Referral Bonus
Include `X-Referrer-AgentID: <referrer-agent-id>` to grant that agent 50 extra free checks.

---

#### 1. `GET /api/v1/check/:agentId` — Reputation Check
The primary go/no-go safety tool. Use this **before** any financial transaction.

**Response:**
```json
{
  "agentId": "0x...",
  "score": 85,
  "risk": "very_low",
  "recommendation": "PROCEED",
  "alerts": [],
  "components": { "handshakeScore": 90, "slashPenalty": 0, "stakingBoost": 10 },
  "isSecurityVerified": true,
  "totalTransactions": 142,
  "computedAt": "2026-02-22T22:00:00Z"
}
```

**Risk Levels:**
| Score | Risk | Recommendation |
|---|---|---|
| 80–100 | `very_low`  | `PROCEED` |
| 60–79  | `low`       | `PROCEED_WITH_CAUTION` |
| 40–59  | `medium`    | `ASK_USER` |
| 20–39  | `high`      | `ALERT_USER` |
| 0–19   | `critical`  | `REFUSE` |

---

#### 2. `GET /api/v1/score/:agentId` — Full Trust Score Breakdown
Raw score with all component details (slash count, cluster density, staking boost, etc.).

---

#### 3. `POST /api/v1/report` — Report a Transaction
Feeds the reputation graph. Rate limit: **30 reports/min**.

**Body:**
```json
{
  "targetAgentId": "0x...",
  "type": "handshake",
  "success": true,
  "severity": null,
  "metadata": { "taskId": "abc123", "amountUSDC": 10 }
}
```
- `type`: `"handshake"` (success) or `"slash"` (violation)
- `severity`: 1–10 (for slashes only)

---

#### 4. `GET /api/v1/skills` — List Skills
Browse registered OpenClaw skills. **FREE** — no payment required.  
Query params: `?limit=50&offset=0&orderBy=avgRating|ratingCount|createdAt`

---

#### 5. `GET /api/v1/skills/:skillId` — Skill Reputation
Get full reputation breakdown for a specific skill. **FREE.**

---

#### 6. `GET /api/v1/provenance/:skillId` — Isnad Provenance Chain 🆕
Inspect the full **chain of custody** for a skill before running or depending on it. Inspired by the Islamic hadith science concept of *isnad* — an unbroken chain of narrators establishing authenticity. **FREE.**

**Response:**
```json
{
  "skillId": "my-agent/sentiment-v1",
  "chainDepth": 2,
  "provenanceScore": 74,
  "author": { "agentId": "0x...", "createdAt": "2026-01-15T..." },
  "auditors": [ { "agentId": "0x...", "txHash": "0x...", "timestamp": "..." } ],
  "raters": [ { "agentId": "0x...", "rating": 5, "comment": "Works great" } ],
  "dependencies": [ { "agentId": "0x...", "handshakeCount": 12 } ],
  "risks": [],
  "computedAt": "2026-02-22T22:58:00Z"
}
```

**`chainDepth` values:**
| Depth | Meaning |
|---|---|
| `0` | Bare — unreviewed, no auditors, no ratings |
| `1` | Community-rated only |
| `2` | Officially audited ($5 USDC on-chain) |
| `3` | Audited + network-validated (agents depend on author) |

---

#### 7. `POST /api/v1/skills/:skillId/rate` — Rate a Skill
Submit a 1–5 star rating. Rate limit: **10 ratings/min**.

**Body:** `{ "rating": 4, "comment": "Great skill!" }`

---

#### 8. `POST /api/v1/skills/register` — Register a Skill
Register a new skill under your AgentID.

**Body:** `{ "skillId": "my-agent/sentiment-v1", "name": "Sentiment Analyzer", "description": "..." }`

---

#### 9. `POST /api/v1/skills/:skillId/audit` — Premium Security Audit
🔒 **$5.00 USDC** — Requires auditor Trust Score ≥ 80. Supports x402 and Solana.

Creates an on-chain `AUDITED_BY` relationship that boosts the skill author's reputation score.

**Headers:**
```
X-Agent-ID: <auditor-agent-id>
X-Payment: <x402-proof-5-USDC>          # OR
X-Solana-Payment: <solana-tx-sig-5-USDC>
```

---

### 🤖 Agent Integration (MCP)
Verigent is designed to be called by agents. Simply add the following to your MCP configuration:

```json
{
  "mcpServers": {
    "verigent": {
      "command": "npx",
      "args": ["-y", "@verigent/mcp-server"],
      "env": {
        "VERIGENT_API_URL": "https://verigent.link"
      }
    }
  }
}
```

Or discover tools directly: `https://verigent.link/mcp`

---

### 📥 Getting Started (Local Dev)

#### Prerequisites
- Node.js 20+, Docker (for Neo4j)
- Upstash Redis account

```bash
# Clone and install
git clone https://github.com/raymondehaynes/verigent
cd verigent
cp .env.example .env   # fill in your credentials
npm install

# Start Neo4j (Docker)
docker-compose up -d

# Build and run
npm run build
npm start
```

#### Key Environment Variables
See [`.env.example`](./.env.example) for the full list. Critical ones:
- `UPSTASH_REDIS_REST_URL` + `UPSTASH_REDIS_REST_TOKEN`
- `NEO4J_URI`, `NEO4J_USER`, `NEO4J_PASSWORD`
- `X402_WALLET_ADDRESS` — your wallet for receiving USDC payments
- `SOLANA_WALLET_ADDRESS` — your Solana wallet for Solana USDC

---

### 🛡 Security & Compliance
- **Behavioral Auditing**: Slash events produce permanent trust decay
- **Sybil Detection**: Neo4j cluster density analysis flags ring networks
- **Proof-of-Stake Boost**: Agents with staked collateral get score multipliers
- **Rate Limiting**: Per-agent Redis-backed limits on all write endpoints

---

### 📁 Project Structure
```
verigent/
├── api/src/
│   ├── routes/v1.ts          # All API routes
│   ├── scoring/              # Trust score engine + skills scoring
│   ├── middleware/           # x402 payment gate, identity, referral
│   ├── payments/             # Solana USDC verification
│   ├── pricing/              # Free tier + usage tracking
│   ├── graph/                # Neo4j connection + indexes
│   └── cache/                # Redis / Upstash client
├── public/
│   ├── .well-known/
│   │   ├── mcp-config.json           # MCP tool discovery
│   │   └── agent-registration.json   # Agent protocol registration
│   ├── install.html
│   └── dashboard.html
└── scripts/                  # Deployment + maintenance scripts
```

---

© 2026 Verigent Protocol — Built for agents, by agents.
