# Valuation — Venture Capital

## Valuation Methods by Stage

### Pre-Seed and Seed
| Method | Approach | When to Use |
|--------|----------|-------------|
| Comparable transactions | What did similar companies raise at? | Most common |
| Scorecard | Weight team, market, product factors | Early teams |
| Berkus | Assign value to risk reduction | Pre-revenue |

**Reality:** Early-stage valuations are art, not science. Driven by supply/demand of capital.

### Series A and Beyond
| Method | Formula | Best For |
|--------|---------|----------|
| Revenue multiple | ARR x multiple | SaaS companies |
| GMV multiple | GMV x take rate x multiple | Marketplaces |
| DCF | Discounted future cash flows | Mature companies |
| Comparable companies | Based on public comps | Later stages |

## SaaS Valuation Multiples

### ARR Multiples by Growth Rate
| Growth Rate | Typical Multiple | Context |
|-------------|-----------------|---------|
| Under 50% | 5-10x ARR | Normal growth |
| 50-100% | 10-20x ARR | Strong growth |
| Over 100% | 20-40x ARR | Hypergrowth |
| Over 200% | 40x+ ARR | Exceptional, rare |

### Adjustments to Multiple
| Factor | Effect |
|--------|--------|
| Net revenue retention over 120% | +20-50% |
| Gross margins over 80% | +10-20% |
| CAC payback under 12 months | +10-20% |
| Market leader position | +20-30% |
| Regulatory risk | -20-40% |
| Customer concentration | -10-30% |

## Marketplace Valuation

### Key Metrics
| Metric | Definition | Target |
|--------|------------|--------|
| GMV | Total transaction value | Growth rate |
| Take rate | Revenue / GMV | 10-20% typical |
| Net revenue | GMV x take rate | Actual revenue |

### Multiple Application
```
Valuation = Net Revenue x Multiple

Where multiple depends on:
- Growth rate (higher = higher multiple)
- Unit economics (contribution margin)
- Market size and share
- Network effects strength
```

## Consumer and B2C

### Engagement-Based Valuation
| Metric | Use Case |
|--------|----------|
| DAU/MAU | Social and content apps |
| Revenue per user | Subscription products |
| LTV | E-commerce and gaming |

### Per-User Valuations (Historical Ranges)
| Type | Range per User |
|------|---------------|
| Social network | $20-100 |
| Subscription service | $100-500 |
| E-commerce | $50-200 |
| Gaming | $10-50 |

**Note:** These vary wildly by market and timing.

## DCF for Later Stage

### Formula
```
Value = Sum of (FCF_t / (1 + r)^t) + Terminal Value

Where:
FCF = Free Cash Flow
r = Discount rate (typically 20-40% for private companies)
t = Year
Terminal Value = FCF_final x (1 + g) / (r - g)
```

### Discount Rates by Stage
| Stage | Typical Discount Rate |
|-------|----------------------|
| Seed | 50-70% |
| Series A | 40-60% |
| Series B | 30-50% |
| Series C+ | 20-40% |

## Valuation Negotiation

### Founder Perspective
- Higher valuation = less dilution
- But: sets expectations for next round
- Down rounds damage morale and signal

### Investor Perspective
- Lower valuation = more ownership
- But: must be fair to attract good founders
- Excessive dilution kills motivation

### Finding the Zone
```
Fair valuation balances:
- Enough ownership for founders to stay motivated
- Enough ownership for investors to justify risk
- Reasonable step-up expected for next round
```

## Common Mistakes

### Overvaluation Risks
- Cannot raise next round at higher price
- Down round triggers anti-dilution
- Employees disillusioned by underwater options

### Undervaluation Risks
- Excessive founder dilution
- Less runway from same capital
- Signals weak negotiating position

## Quick Sanity Checks

### For Seed
- $3-5M post-money for pre-product
- $5-10M post-money for early revenue
- $10-15M post-money for strong traction

### For Series A
- 10-15x ARR for strong SaaS
- $15-30M post-money typical range
- Need clear path to $100M+ revenue

### For Series B+
- Based on comparable public companies
- Apply private company discount (20-40%)
- Factor in growth rate and profitability
