# Term Sheets — Venture Capital

## Key Economic Terms

### Valuation
| Term | Definition | Standard |
|------|------------|----------|
| Pre-money | Company value before investment | Negotiated |
| Post-money | Pre-money + investment amount | Calculated |
| Price per share | Post-money / fully diluted shares | Calculated |

### Liquidation Preference
| Type | Meaning | Investor Friendly |
|------|---------|------------------|
| 1x non-participating | Get money back OR convert to common | Standard, fair |
| 1x participating | Get money back AND share remaining | Aggressive |
| 2x+ preference | Multiple of investment first | Very aggressive |

**Rule:** Push for 1x non-participating as industry standard.

### Anti-Dilution Protection
| Type | Effect | Standard |
|------|--------|----------|
| Weighted average (broad) | Adjusts based on new shares issued | Standard |
| Weighted average (narrow) | Same but excludes some shares | Acceptable |
| Full ratchet | Reprices to new lower price | Aggressive, avoid |

### Option Pool
- Pre-money inclusion means founders pay for dilution
- Post-money inclusion means new investors share dilution
- Standard: 10-20% pool, pre-money

## Key Control Terms

### Board Composition
| Stage | Typical Structure |
|-------|------------------|
| Seed | 2 founders, 1 investor or 3 founders |
| Series A | 2 founders, 1 investor, 1 independent |
| Series B+ | 2 founders, 2 investors, 1 independent |

### Protective Provisions
Standard provisions (investor approval required):
- Change of control or sale
- New equity issuance
- Changes to charter
- Taking on debt above threshold
- Changing board size

**Avoid:** Operational veto rights that slow down company

### Information Rights
- Monthly financials
- Annual budget and plan
- Cap table access
- Board observer rights (if no seat)

## Investor Rights

### Pro-Rata Rights
- Right to invest in future rounds to maintain ownership
- Standard for institutional investors
- May include pay-to-play provisions

### Registration Rights
| Type | Meaning |
|------|---------|
| Demand | Can force IPO registration |
| Piggyback | Can join company-initiated registration |
| S-3 | Simplified registration after IPO |

### Right of First Refusal (ROFR)
- Company or investors can match third-party offers for shares
- Standard, but should have reasonable time limits

## Founder-Friendly Terms

### What to Negotiate For
- Single-trigger acceleration on acquisition
- Reasonable vesting (4 years, 1 year cliff)
- Founder-friendly board composition early
- Limited protective provisions
- Carve-outs for small transactions

### What to Avoid
- Full participating preferred
- Full ratchet anti-dilution
- Excessive board seats for small checks
- Redemption rights
- Cumulative dividends

## Term Sheet Red Flags

| Red Flag | Risk |
|----------|------|
| Excessive structure | Returns flow to investors, not founders |
| Many protective provisions | Slows down operations |
| Pay-to-play without flexibility | Punishes investors who cannot follow on |
| Short exclusivity with many conditions | Not serious about closing |
| No-shop extending beyond 60 days | Too much control |

## Negotiation Strategy

### For Founders
1. Get multiple term sheets if possible
2. Focus on valuation AND terms together
3. Understand long-term implications of structure
4. Get a good lawyer, do not negotiate alone

### For Investors
1. Price reflects risk at this stage
2. Structure protects downside, not upside
3. Align incentives for long-term partnership
4. Leave room for future investors
