# Due Diligence — Venture Capital

## Pre-Investment Checklist

### Team Assessment
| Area | Questions | Red Flags |
|------|-----------|-----------|
| Background | Previous exits? Domain expertise? | Inflated titles, gaps in history |
| Dynamics | How did founders meet? Who decides? | Recent co-founder addition, unclear roles |
| Commitment | Full-time? Vesting? | Advisors listed as co-founders |
| References | What do former colleagues say? | Refuses to provide references |

### Product Diligence
| Area | Verify |
|------|--------|
| Technology | Is it real? Demo vs slides |
| IP | Patents filed? Trade secrets? |
| Technical debt | Architecture scalable? |
| Dependencies | Single point of failure? Key vendor risk? |

### Market Diligence
| Area | Method |
|------|--------|
| Market size | Bottoms-up calculation from customers |
| Growth rate | Third-party data, not founder projections |
| Competitive landscape | Map all funded competitors |
| Customer interviews | Talk to 5-10 customers directly |

### Financial Diligence
| Document | What to Look For |
|----------|-----------------|
| Cap table | Clean structure, no complex instruments |
| Revenue | Recognize correctly, not inflated |
| Burn rate | Runway matches stated plans |
| Unit economics | Trending positive or explained |

## Customer Reference Calls

### Questions to Ask
1. How did you find this product?
2. What problem does it solve for you?
3. What would you use if this did not exist?
4. Would you recommend to a peer? Why?
5. What is missing or frustrating?

### Warning Signs
- Customers were incentivized to talk to you
- Only flagship customers provided
- Users cannot articulate the value
- High churn when you dig deeper

## Technical Due Diligence

### For Software Companies
```
Architecture review:
- Scalability: Can it handle 10x users?
- Security: Penetration testing done?
- Data: GDPR/privacy compliance?
- Infra: Cloud-native or legacy?
```

### For Deep Tech
- Independent technical expert review
- Patent landscape analysis
- Regulatory pathway clarity
- Time to market realistic

## Legal Diligence

### Must Review
- Corporate formation documents
- Employment agreements (IP assignment)
- Customer contracts (terms, concentration)
- Pending litigation or threats
- Regulatory compliance status

### Cap Table Red Flags
- Excessive option pool used already
- Previous investors with blocking rights
- Convertible notes stacking up
- Founder shares not vesting

## Deal Breakers

Hard pass if any of these:
- Founders lie or hide information
- Irreconcilable cap table issues
- Regulatory risk without mitigation plan
- No path to ownership of core IP
- Customer concentration over 50% in one account
