# Venice Visitor Tips

## Essential Knowledge

### The €5 Entry Fee (2024+)
Venice charges day-trippers €5 on peak days (weekends, holidays, Apr-Jul).
- **Who pays**: Day visitors not staying overnight
- **Exempt**: Hotel guests, residents, students, workers, children under 14
- **How**: QR code purchased online, random checks
- **Reality**: Enforcement spotty but fines €50-300

Check calendar at `canientervenice.it` for fee days.

### Water Everywhere
- **Drink**: Tap water safe and free. Fill bottles at fountains.
- **Toilets**: €1.50 public toilets. Cafés require purchase.
- **Acqua alta**: Flooding Oct-Mar. Check `comune.venezia.it/maree` forecast.
- **Swimming**: Forbidden in canals. Fines up to €500.

### Getting Lost
You will get lost. This is correct.
- **Every path leads somewhere** — There are no true dead ends, just "cul-de-sacs" ending at water
- **Follow "Per San Marco" / "Per Rialto"** — Yellow signs point to major areas
- **Campaniles** — Bell towers visible from distance for orientation
- **Maps are semi-useful** — Alleys too narrow to show. Google Maps works but slowly.
- **Vaporetto stops** — When truly lost, find water, find a stop

### Bridges & Steps
- **400+ bridges** — All have steps (except rare modern ones)
- **No ramps** — Wheelchairs/strollers extremely difficult
- **Wet = slippery** — Stone gets dangerous after rain
- **Handrails rare** — Watch your step, especially at night

---

## Money Matters

### Cash vs Card
- **Cards accepted**: Most restaurants, shops, hotels
- **Cash needed**: Small bacari, market vendors, some churches
- **ATMs**: Abundant but €3-5 foreign card fees
- **Tip**: Bank ATMs (not independent ones) have better rates

### Tipping
Italian tipping is minimal:
- **Restaurants**: Round up or leave €2-5. "Servizio" on bill = tip included.
- **Bars**: Leave change at bar
- **Hotels**: €1-2/day housekeeping, €5 porterage
- **Gondoliers**: Not expected (it's €80+), but €5-10 for exceptional service

### Common Scams & Ripoffs
- **San Marco pricing**: €15 for a spritz that's €4 elsewhere
- **Menu without prices**: Always ask or walk away
- **"Fresh" fish: Frozen actually**: Asterisk (*) means frozen
- **Rose sellers**: Pushy, overpriced, sometimes aggressive
- **"Free" photos: Then demand payment**: Just say no
- **Fake Murano glass**: No certificate = likely fake

---

## Communication

### Language Basics
| English | Italian | Pronunciation |
|---------|---------|---------------|
| Hello | Ciao / Buongiorno | Chow / Bwon-JOR-no |
| Thank you | Grazie | GRAT-see-eh |
| Please | Per favore | Pair fa-VOR-ay |
| Excuse me | Scusi | SKOO-zee |
| How much? | Quanto costa? | KWAN-toh KOS-ta |
| The bill | Il conto | Eel KON-toh |
| One coffee | Un caffè | Oon kah-FEH |
| Cheers! | Cin cin! | Chin chin |

### Venetian Dialect
Venetians have their own language (Veneto), different from Italian:
- **Ciao** originated in Venice (from "s'ciavo" = I am your slave)
- **Ombra** = glass of wine (shadow of the campanile where vendors stood)
- **Spritz** = Venetian invention
- **Bacaro** = Venetian wine bar (not used elsewhere in Italy)

### Phone & Internet
- **WiFi**: Hotels have it, cafés less common than other cities
- **EU roaming**: Works for EU phones
- **US phones**: Check international plans; local SIM at TIM/Vodafone shops €20-30

---

## Day Trips

### From Venice (by Vaporetto/Train)

#### Murano, Burano, Torcello
- **Transport**: Vaporetto Lines 4.1, 4.2, 12
- **Time**: Half day minimum, full day for all three
- **Cost**: Included in vaporetto passes
- **Don't miss**: Morning glass demo (Murano), lunch in Burano, cathedral (Torcello)

#### Chioggia
- **Transport**: Bus from Lido or boat
- **Time**: 4-5 hours
- **Cost**: ~€20 round trip
- **Why go**: "Little Venice" without crowds, fishing village authenticity

#### Lido
- **Transport**: Vaporetto lines 1, 5.1, 5.2 (10-20 min)
- **Cost**: Included in passes
- **Why go**: Beach, cycling, Film Festival atmosphere (September)

### From Venice (by Train)

#### Padua (Padova)
- **Transport**: Train 25-50 min, €5-15
- **Why go**: Giotto frescoes (Scrovegni Chapel — BOOK AHEAD), university, cheaper everything
- **Time**: 4-6 hours

#### Verona
- **Transport**: Train 1h-1h20, €10-20
- **Why go**: Roman arena, Romeo & Juliet balcony (touristy but fun), beautiful centro
- **Time**: Full day

#### Bologna
- **Transport**: Train 1h30, €15-30
- **Why go**: Best food city in Italy, porticoes, university energy
- **Time**: Full day

#### Vicenza
- **Transport**: Train 45 min, €5-12
- **Why go**: Palladio architecture (UNESCO), Teatro Olimpico
- **Time**: 4-5 hours

#### Treviso
- **Transport**: Train 30 min, €4-8
- **Why go**: Prosecco day trips, canals without crowds, cheaper Ryanair airport
- **Time**: 3-4 hours or as base

### Prosecco Wine Region
- **Transport**: Train to Treviso, then car/tour
- **Tours**: €60-150 for guided day trip with tastings
- **DIY**: Rent car in Treviso, drive Valdobbiadene hills
- **Best time**: Fall harvest (September-October)

---

## Photography Tips

### Best Light Times
- **Sunrise (6-7am)**: San Marco empty, golden light on basilica
- **Mid-morning (9-11am)**: Rialto market activity, good light in canals
- **Sunset**: Zattere, San Giorgio, Accademia Bridge
- **Blue hour**: Grand Canal reflections, campanile lights

### Classic Shots
- Rialto Bridge from below (San Polo side)
- San Giorgio Maggiore from Piazzetta
- Grand Canal from Accademia Bridge
- Burano colored houses (morning light)
- Gondolas at Bacino Orseolo
- Morning fog in winter (if lucky)

### Photography Rules
- **Tripods**: Technically need permit in San Marco, rarely enforced elsewhere
- **Drones**: Illegal in city center without special permit
- **Churches**: Usually no flash, sometimes no photos (signs will indicate)
- **People**: Ask permission for portraits

### Avoiding Crowds in Photos
- Arrive at sunrise (6-7am)
- Visit during lunch (12-2pm) when restaurants full
- Low season (Nov-Feb, excluding Carnevale)
- Long exposures to blur crowds (need tripod)

---

## Seasonal Considerations

### Spring (Mar-May)
- **Weather**: 15-22°C, rain possible
- **Crowds**: Building from Easter
- **Events**: La Sensa (May), Vogalonga rowing race (May)
- **Tip**: Layers essential, can change quickly

### Summer (Jun-Aug)
- **Weather**: 25-35°C, humid, mosquitoes
- **Crowds**: Peak, especially Jul-Aug
- **Events**: Redentore Festival (July), Venice Film Festival starts late Aug
- **Tip**: Start early, siesta midday, evening activity

### Fall (Sep-Nov)
- **Weather**: 15-25°C (Sept), 8-15°C (Nov)
- **Crowds**: Still busy Sept, thinning Oct-Nov
- **Events**: Regata Storica (Sept), Art Biennale (odd years)
- **Tip**: Best overall time. Nov brings acqua alta risk.

### Winter (Dec-Feb)
- **Weather**: 2-10°C, fog, acqua alta likely
- **Crowds**: Lowest (except Carnevale)
- **Events**: Carnevale (Feb usually)
- **Tip**: Magical atmosphere, pack boots, some closures

---

## Packing Essentials

### Must-Haves
- **Comfortable walking shoes** — You'll walk 10-20 km/day on stone
- **Layers** — Temperature varies, churches are cold
- **Compact umbrella** — Rain comes without warning
- **Reusable water bottle** — Fill at fountains
- **Small daypack** — Not big backpack (awkward on boats/crowds)
- **Portable charger** — For all that photo-taking

### Seasonal Additions
- **Summer**: Sunscreen, mosquito repellent, hat, light scarf (churches)
- **Winter**: Rain boots or waterproof shoes (acqua alta), warm coat
- **Acqua alta season**: Plastic boot covers (buy locally, €10) or wellies

### Nice-to-Haves
- **Binoculars**: For mosaics/ceiling details
- **Offline maps**: Download Google Maps Venice offline
- **Tide app**: For acqua alta forecasting

---

## Common Mistakes

### Planning
- ❌ Only booking 1 day
- ❌ Staying in Mestre to "save money" (you lose time/experience)
- ❌ Not booking San Marco slot
- ❌ Visiting in August expecting empty streets

### Logistics  
- ❌ Wheeled suitcase over cobblestones/bridges (nightmare)
- ❌ Not having vaporetto pass (individual tickets add up fast)
- ❌ Taking wrong vaporetto direction (check signs carefully)
- ❌ Walking everywhere when vaporetto makes sense

### Experience
- ❌ Eating near San Marco (tourist trap)
- ❌ Paying to sit when standing is 5x cheaper
- ❌ Only seeing San Marco area
- ❌ Rushing (Venice rewards slow exploration)
- ❌ Not getting lost on purpose

---

## Emergency Info

### Emergency Numbers
- **General emergency**: 112 (EU-wide)
- **Police (Carabinieri)**: 112
- **Medical emergency**: 118
- **Fire**: 115

### Medical
- **Hospital**: Ospedale Civile SS. Giovanni e Paolo (Castello)
- **Pharmacies**: Green cross signs, some 24-hour
- **EU health card (EHIC)**: Works for EU citizens

### Lost/Stolen
- **Passport**: Contact your embassy (most in Rome, consulates in Venice)
- **Cards**: Call bank immediately
- **Police report**: Questura di Venezia, Santa Croce 500
