# Venice Attractions Guide

## Tier 1: Unmissable

### Basilica di San Marco
The crown jewel of Venice. Byzantine masterpiece with gold mosaics covering 8,000 sqm.

**Reality check**:
- Free entry to basilica (book timed slot to skip line)
- Treasury and Pala d'Oro cost extra (€5 each) — worth it
- Museum/Loggia €7 — access to terrace with square views
- No shorts, bare shoulders — strict dress code
- 10-15 min visit limit enforced in peak season

**Strategy**: Book €3 skip-the-line slot online. Go at 9:30am or after 4pm. The mosaics are best in morning light.

### Palazzo Ducale (Doge's Palace)
Gothic masterpiece, seat of Venetian power for 700 years. Tintoretto's Paradise (world's largest oil painting), Bridge of Sighs, prison cells.

**Reality check**:
- Book timed entry (€30 or Museum Pass)
- 2-3 hours minimum for proper visit
- "Secret Itineraries" tour (€28 extra) reveals hidden rooms — excellent
- Bridge of Sighs connects to prisons — included in visit

**Strategy**: Morning or late afternoon. Combine with Correr Museum (same ticket). Secret Itineraries books out weeks ahead.

### Rialto Bridge & Market
16th-century stone bridge, iconic silhouette. Morning fish and produce market (Tue-Sat).

**Reality check**:
- Bridge itself: free, always crowded
- Market: 7am-12pm only, closed Sun-Mon
- Fish market (Pescheria) most photogenic
- Produce market (Erberia) great for picnic supplies

**Strategy**: Visit market at 8am for atmosphere. Bridge at sunrise or sunset for photos. Skip shops ON the bridge (tourist traps).

### Gallerie dell'Accademia
Definitive Venetian art collection. Bellini, Titian, Tintoretto, Veronese, Canaletto.

**Reality check**:
- €15 or Museum Pass
- 2-3 hours for proper visit
- Renovation ongoing — some rooms closed
- Vitruvian Man (da Vinci) shown rarely — check schedule

**Strategy**: Go at 2pm when morning crowds thin. Start upstairs (chronological). Don't miss Bellini's Madonnas, Veronese's Feast.

### Peggy Guggenheim Collection
Modern art in her former palazzo on Grand Canal. Pollock, Picasso, Dalí, Ernst, Magritte.

**Reality check**:
- €18 — not on Museum Pass
- Small but excellent — 1.5-2 hours
- Garden with Marino Marini sculpture
- Peggy's grave in garden (with her dogs)

**Strategy**: Wed evenings extended hours with fewer crowds. Combine with Dorsoduro walk. Café terrace on Grand Canal.

## Tier 2: Highly Recommended

### Santa Maria della Salute
Baroque church at Grand Canal entrance. Built as plague thanksgiving (1630s). Dramatic dome, Titian paintings.

**Reality check**:
- Church free, sacristy €6 (has the Titians)
- Fewer crowds than San Marco
- Best photographed from across Grand Canal

### Scuola Grande di San Rocco
"Sistine Chapel of Venice." Tintoretto's career masterpiece — 60+ paintings on walls and ceilings.

**Reality check**:
- €10
- 1-2 hours
- Bring binoculars or mirrors provided
- Less crowded than major museums

### Murano Island
Glass-making island 10 min by vaporetto. Furnace demonstrations, glass museum, quieter than Venice.

**Reality check**:
- Free vaporetto rides from Venice (Lines 4.1, 4.2)
- Free furnace shows (they'll push sales after)
- Glass Museum €12 — worth it for history
- Authentic glass has certificate — ask

**Strategy**: Morning for furnace demos (they stop midday). Stay for lunch — cheaper than Venice. Combine with Burano.

### Burano Island
Colorful fishermen's houses, lace tradition, excellent seafood.

**Reality check**:
- 40 min from Venice (Line 12)
- Half-day trip with Murano
- Real lace is expensive (€200+ for small piece)
- Overrun 10am-3pm — go early or late

### San Giorgio Maggiore
Palladio church on island facing San Marco. Bell tower has best Venice panorama.

**Reality check**:
- Church free, campanile €8
- 2 min vaporetto from San Marco
- Far fewer tourists than San Marco campanile
- Tintoretto Last Supper inside

**Strategy**: Best at sunset — campanile stays open late. The view beats San Marco campanile in every way.

## Tier 3: Worth Visiting

### Ca' Rezzonico
18th-century Venice museum. Period rooms, Tiepolo ceilings, Canaletto views.
- €10
- Gorgeous Grand Canal palazzo
- Less crowded gem

### Ca' d'Oro
Gothic palazzo, Franchetti Gallery. Mantegna, beautiful Grand Canal views.
- €6
- Small but beautiful
- Perfect 45-min visit

### Chiesa dei Frari
Gothic church with Titian masterpieces (Assumption, Pesaro Madonna), Bellini altarpiece.
- €5
- Major art church
- Quieter than San Marco

### Torcello Island
Oldest settlement in lagoon. Byzantine cathedral (Madonna mosaic), near-deserted atmosphere.
- 45 min from Venice
- Cathedral €5
- Combine with Burano (5 min away)
- Hemingway's escape — now peaceful day trip

## Skip or Deprioritize

### San Marco Campanile
**Why skip**: 2+ hour waits. San Giorgio Maggiore campanile has same view, no line.

### Fenice Opera House
**Why skip**: Only worth it for a performance. Tour of empty theater underwhelming for €13.

### Museo Correr
**Why deprioritize**: Included in Ducale ticket, so visit. But don't prioritize — mainly Venetian history.

### "Secret Venice" Walking Tours
**Why skip**: Most "secrets" are public knowledge. Self-guide with free Chiesa Pass churches instead.

### Gondola Serenade Add-ons
**Why skip**: Accordion player in another boat. Awkward and expensive (€50+ extra).

## Hidden Gems

### Scala Contarini del Bovolo
Hidden spiral staircase, rooftop views. €8, few tourists know it.

### Chiesa di San Sebastiano
Entire interior painted by Veronese — his Sistine Chapel. €3 Chorus Pass.

### Libreria Acqua Alta
Bookshop with books in gondolas and bathtubs (flood protection). Free, photogenic, cats.

### Fondaco dei Tedeschi Rooftop
Free rooftop terrace above DFS store. Book free slot online. Best free view in Venice.

### Giudecca Island
Local residential island. No cars like Venice, but no tourists either. Authentic, peaceful.

## Museum Passes

### Venice Museum Pass (€40)
11 civic museums including Doge's Palace, Correr, Ca' Rezzonico, Ca' Pesaro, Murano Glass Museum.
**Worth it if**: Visiting 3+ included museums.

### Chorus Pass (€14)
18 churches including Frari, San Sebastiano, Madonna dell'Orto.
**Worth it if**: Art/architecture focused. Individual churches €3 each.

### Venezia Unica City Pass
Combines transport + museums + services. Calculate if actually cheaper for your plans.

## Booking Strategy

1. **Basilica San Marco**: Book free timed slot online (€3 booking fee, worth it)
2. **Doge's Palace**: Book timed entry, especially high season
3. **Accademia**: Usually walkable, but book for certainty
4. **Guggenheim**: Book online, especially weekends
5. **Secret Itineraries (Ducale)**: Book 2+ weeks ahead

## Cruise Ship Avoidance

Check `veneziacruises.it` for daily ship arrivals:
- **8am-10am**: Ships arriving, passengers flooding San Marco
- **10am-4pm**: Peak cruise passenger time
- **4pm-6pm**: Ships departing, exodus to port
- **Best strategy**: Visit main sites before 9am or after 5pm on ship days
