# Venice Safety Guide

## Overview

Venice is one of Europe's safest cities. Violent crime is almost nonexistent. Main concerns: petty theft, scams, and water hazards.

---

## Crime

### Reality
- **Violent crime**: Extremely rare
- **Pickpocketing**: Main concern, concentrated in tourist areas
- **Theft from bags**: Crowded vaporetti, San Marco area
- **Night safety**: Very safe, streets just get empty

### Pickpocket Hotspots
- Vaporetto Line 1 (crowded tourist route)
- San Marco Piazza and surroundings
- Rialto Bridge area
- Train station
- Any crowded area during peak hours

### Prevention
- Front pocket or money belt for valuables
- Bags across body, in front
- Don't flash expensive items
- Be aware in crowds
- Backpack in front on vaporetti

### If Targeted
- Report to Carabinieri (police)
- File police report for insurance
- Cancel cards immediately
- Passport: Contact embassy

---

## Scams

### Common Scams

**Restaurant Scams**
- Unlisted prices (always check menu)
- Fish charged by weight (confirm before ordering)
- Seat + service fees not mentioned
- Changing your order in kitchen

**Gondola Scams**
- Price changing mid-ride
- Shorter duration than agreed
- "Special route" upsells

**Shopping Scams**
- Fake Murano glass
- Counterfeit goods
- Inflated prices for "antiques"

**Street Scams**
- Rose sellers (aggressive, overpriced)
- "Free" bracelets then demand payment
- Fake petitions hiding theft
- Bird food sellers (€20 fine for feeding pigeons)

### Avoidance
- Check prices before ordering/buying
- Agree on gondola price AND duration in writing
- Ask for Murano glass certificates
- Say "No grazie" firmly and walk away
- Don't sign anything on street

---

## Water Safety

### Canal Hazards
- **Swimming**: Illegal, €350 fine. Also dangerous (currents, pollution, boats)
- **Falling in**: Rare but happens (no barriers)
- **Drunk near water**: Major risk — take care at night
- **Boat traffic**: Don't lean too far on vaporetti

### Acqua Alta (Flooding)
- **When**: October-March, especially Nov-Dec
- **Depth**: Usually 20-50cm, occasionally 100cm+
- **Warnings**: Sirens (different tones for different levels)
- **Forecast**: Check comune.venezia.it/maree

**During Acqua Alta**:
- Elevated walkways appear on main routes
- Some vaporetto stops close
- Rubber boots or plastic covers essential
- San Marco floods first (lowest point)

---

## Health

### Medical Emergencies
- **Emergency**: 118
- **Hospital**: Ospedale Civile SS. Giovanni e Paolo (Castello)
- **Pharmacies**: Green cross signs, some 24-hour

### Pharmacies (Farmacie)
- Well-stocked with OTC medicines
- Pharmacists can advise on minor ailments
- Some 24-hour pharmacies

### Common Issues
- **Walking fatigue**: 10-20km/day on stone — rest feet
- **Dehydration**: Drink water, especially summer
- **Sunburn**: Summer sun intense with water reflection
- **Mosquitoes**: Near canals at dusk (repellent helps)

### Health Cards
- EU citizens: EHIC/GHIC card for free emergency care
- Non-EU: Travel insurance essential
- Private clinics: Available but expensive

---

## Legal Issues

### Things to Know
- **ID**: Carry passport or ID (technically required)
- **Drugs**: Zero tolerance, even cannabis
- **Public drinking**: Legal but fines for glass bottles in some areas
- **Smoking**: Banned in many outdoor areas
- **Sitting**: Fines for sitting in prohibited areas (San Marco steps, etc.)

### Fines
| Offense | Fine |
|---------|------|
| Feeding pigeons | €25-700 |
| Sitting in prohibited areas | €50-200 |
| Swimming in canals | €350+ |
| Littering | €100-500 |
| Cycling (in center) | €50-200 |
| Glass on bridges (some areas) | €100+ |

### If Arrested
- Remain calm, cooperative
- Don't sign anything you don't understand
- Contact embassy
- You have right to lawyer

---

## Weather Hazards

### Summer (June-August)
- **Heat**: 30-35°C, humid
- **Dehydration**: Drink water constantly
- **Sun**: Reflect off water, wear sunscreen/hat
- **Crowds**: Overwhelming, plan around

### Winter (November-February)
- **Acqua alta**: Flooding risk
- **Cold**: 2-10°C, damp
- **Fog**: Can be disorienting
- **Slippery**: Wet stone is dangerous

### All Seasons
- **Wet stone**: Slippery when wet
- **Bridge steps**: Watch your step, no handrails often
- **Night darkness**: Some areas very dark (bring phone flashlight)

---

## Emergency Contacts

| Service | Number |
|---------|--------|
| General emergency | 112 |
| Police (Carabinieri) | 112 |
| Medical emergency | 118 |
| Fire | 115 |
| Coast guard | 1530 |

### Useful Locations
- **Hospital**: Ospedale Civile, Castello (Campo SS. Giovanni e Paolo)
- **Main Police**: Questura di Venezia, Santa Croce 500
- **Tourist Police**: San Marco area
- **Consulates**: Most in Rome; some consular services in Venice

---

## Personal Safety Tips

### Day
- Be aware of surroundings in crowds
- Bags across body, zipped
- Don't flash expensive items
- Photo equipment: Watch it

### Night
- Venice is safe but quiet
- Some areas very dark
- Last vaporetto ~11:30pm
- Stick to lit areas if unfamiliar
- Know your route home

### Solo Travel
- Very safe city for solo travelers
- Most crowded areas safe
- Quiet areas at night can feel isolated (but are safe)
- Women: Normal city awareness applies

### LGBTQ+ Travel
- Venice is welcoming and safe
- Italy more conservative than Northern Europe
- No issues with PDA in tourist areas
- June has Pride events

---

## Practical Safety

### Drinking Water
- **Tap water**: Safe to drink
- **Fountains**: Throughout city, safe
- **Ask for**: "Acqua del rubinetto" (free)

### Food Safety
- EU standards apply
- Ice is safe
- Seafood fresh (asterisk * means frozen)
- Restaurant hygiene generally good

### Traffic
- **No cars/bikes** in historic center
- **Boats**: Stay aware on waterfront
- **Vaporetti**: Watch the gap when boarding

### Money
- ATMs: Use bank ATMs (Unicredit, Intesa)
- Cards: Widely accepted
- Cash: Carry some for small purchases
- Don't flash large amounts
