# Venice Islands

## Murano

### Overview
Glass-making island, 10 minutes from Venice by vaporetto. Famous for centuries of artisan glasswork. Furnace demonstrations, Glass Museum, and shopping (beware fakes). Quieter than Venice, good for half-day visit.

### Character
- **Tourist density**: Moderate (concentrated at stops)
- **Price level**: €€
- **Authenticity**: Mixed (tourist shops + real artisans)
- **Best time**: Morning for furnace demos

### Key Sights

**Glass Furnaces**
- Free demonstrations (they'll try to sell after)
- Morning only (11am-ish they stop for lunch)
- Interesting regardless of purchase interest
- Look for "Vetro Artistico Murano" trademark

**Museo del Vetro (Glass Museum)**
- €12 or Museum Pass
- History from Roman times
- Impressive pieces
- 1-1.5 hours

**Basilica dei Santi Maria e Donato**
- Byzantine mosaic floor (12th century)
- Dragon bones behind altar (actually whale)
- Free, beautiful

### Buying Glass

**Real vs Fake**
- **Authentic**: "Vetro Artistico Murano" trademark, certificate, high prices
- **Fake**: Made in China, no certificate, suspiciously cheap
- **Reality**: If €20 seems like a deal for Murano glass, it's not Murano glass

**Price Ranges (authentic)**
- Small figurines: €30-100
- Jewelry: €40-200
- Vases: €100-500+
- Chandeliers: €500-50,000+

**Where to Buy**
- Stick to established fornaci (furnaces)
- Ask for certificate of authenticity
- Shipping available for large pieces (€50-200)

### Practical

**Getting There**
- Vaporetto Line 4.1 or 4.2 from Fondamente Nove
- 10-15 minutes
- Included in vaporetto passes

**Eating**
- Cheaper than Venice
- Busa alla Torre (Campo Santo Stefano) — classic
- Acquastanca — modern, quality
- Avoid tourist traps near vaporetto stops

**Time Needed**: 2-3 hours minimum, half day comfortable

---

## Burano

### Overview
Fishing island famous for brightly colored houses and lace tradition. The most photogenic island — every house painted a different color. 40 minutes from Venice, worth the trip for photography and seafood.

### Character
- **Tourist density**: High 10am-4pm, peaceful before/after
- **Price level**: €€
- **Authenticity**: Tourist-focused but genuine fishing community
- **Best time**: 8am arrival (before tour groups) or after 4pm

### Key Sights

**Colored Houses**
- Required by law to maintain
- Originally to help fishermen find home in fog
- Every house different color
- Most photographed view: Via Galuppi reflections

**Lace Museum (Museo del Merletto)**
- €5
- History of Burano lace
- Small but interesting
- 30-45 minutes

**Leaning Campanile**
- More tilted than Pisa
- Can't enter, but visible everywhere

**San Martino Church**
- Free
- Tiepolo painting
- Quick visit

### Buying Lace

**Real vs Fake**
- **Authentic Burano lace**: Hand-made, €200+ for small pieces
- **Fake**: Machine-made (often Chinese), €10-30
- **Reality**: Hand-making lace takes months. If cheap, it's not real.

**Where to Buy**
- Scuola dei Merletti (Lace School) — certified authentic
- Ask to see artisans working
- Certificate of authenticity

### Photography Tips

**Best Spots**
- Via Galuppi (main street) early morning
- Fondamenta di Cavanella — canal reflections
- Any small bridge at sunrise
- Avoid midday (harsh shadows, crowds)

**Timing**
- **8-9am**: Golden light, no tourists
- **10am-4pm**: Crowded, harsh light
- **5-6pm**: Fewer crowds, warm light

### Practical

**Getting There**
- Vaporetto Line 12 from Fondamente Nove
- 40-45 minutes
- Or: 4.1/4.2 to Murano, then Line 12 (same time but two boats)

**Eating**
Venice's best seafood is arguably here:
- **Trattoria al Gatto Nero** — Famous, book ahead
- **Riva Rosa** — Great fish, canalside
- **Da Primo** — Local favorite
- Risotto di gò (goby fish) is local specialty

**Time Needed**: 2-3 hours for photos + lunch. Half day if combining with Murano.

---

## Torcello

### Overview
The origin of Venice. First settlement in lagoon (5th century), once home to 20,000, now population ~15. Near-deserted island with Byzantine cathedral and haunting atmosphere. Peace and history.

### Character
- **Tourist density**: Very low
- **Price level**: €
- **Authenticity**: Very high (nothing to commercialize)
- **Best time**: Anytime, even better in mist

### Key Sights

**Cathedral of Santa Maria Assunta**
- 7th century (Venice's oldest building)
- Byzantine mosaics — Virgin and Child (apse), Last Judgment (west wall)
- €5 entry
- Comparable to Ravenna mosaics
- 45 minutes minimum

**Santa Fosca Church**
- 11th century Byzantine
- Beautiful circular design
- Free, adjacent to cathedral

**Devil's Bridge**
- No railings (original style)
- Legend of devil and builder's wife
- Photo opportunity

**Attila's Throne**
- Stone chair, probably bishop's seat
- Legend says Attila the Hun sat here
- Outside cathedral

**Hemingway's Venice**
- He wrote "Across the River and Into the Trees" nearby
- Stayed at Locanda Cipriani
- Sought peace here

### Practical

**Getting There**
- Vaporetto Line 12 from Burano (5 minutes)
- Or Line 9 direct from Venice (limited service)
- Usually combined with Burano

**Eating**
Only two restaurants:
- **Locanda Cipriani** — Famous, expensive (€80-120/person)
- **Taverna Tipica Veneziana** — Simple, reasonable

**Time Needed**: 1-2 hours. Combine with Burano for half-day.

---

## Lido

### Overview
Long barrier island separating lagoon from Adriatic. Beach resort, completely different from historic Venice. Cars exist here. Venice Film Festival venue. Good for families wanting beach, or as budget accommodation base.

### Character
- **Tourist density**: Moderate (concentrated at beach, Film Festival)
- **Price level**: €€ (cheaper than Venice for accommodation)
- **Authenticity**: Not "Venice" — modern Italian beach town
- **Best time**: Summer for beach, September for Film Festival

### Key Features

**Beaches**
- **Public beaches**: Free, less maintained
- **Private beaches (stabilimenti)**: €20-40/day for umbrella + lounger
- **Water**: Adriatic, clean, calm
- **Season**: June-September

**Gran Viale**
Main street from vaporetto to beach:
- Shops, restaurants, bars
- Liberty (Art Nouveau) architecture
- Bike rentals
- Film Festival atmosphere in September

**Hotel Excelsior & Hotel des Bains**
Grand hotels from Venice's Belle Époque:
- Des Bains: "Death in Venice" (Visconti) filmed here
- Excelsior: Film Festival main venue
- Both worth seeing exteriors

**Jewish Cemetery**
- One of oldest Jewish cemeteries in Europe
- Visits by appointment
- Historical significance

### Film Festival (Late Aug-Early Sep)

**Venice Film Festival** is world's oldest:
- Main venue: Palazzo del Cinema on Lido
- Celebrity sightings
- Public screenings available
- Accommodation triples in price
- Book months ahead

### Practical

**Getting There**
- Vaporetto Line 1, 5.1, 5.2, 6 from Venice
- 15-20 minutes
- Bikes and cars allowed (unlike Venice)

**Getting Around**
- Walk or bike (flat terrain)
- Buses run length of island
- Bike rental €10-15/day

**Eating**
- More casual than Venice
- Beach clubs have restaurants
- Pizza actually good here
- Cheaper than Venice overall

### As Accommodation Base

**Pros**:
- Significantly cheaper than Venice
- Beach access
- More space (real rooms, not tiny)
- Good for families

**Cons**:
- 15-20 min vaporetto each way
- Not "Venice" experience
- Need vaporetto pass (adds cost)
- Last vaporetto ~11:30pm

**Verdict**: Only worth it if: budget is tight + staying 4+ nights + don't mind commute. Otherwise stay in Venice proper.

---

## San Giorgio Maggiore

### Overview
Small island facing San Marco, dominated by Palladio's church. Best view of Venice from its bell tower. 2 minutes by vaporetto. Essential stop.

### Key Sights

**San Giorgio Maggiore Church**
- Palladio masterpiece (1610)
- Tintoretto Last Supper
- White interior, dramatic
- Free entry

**Campanile (Bell Tower)**
- €8
- Best panorama of Venice
- No crowds (unlike San Marco campanile)
- Elevator

**Fondazione Cini**
- Former Benedictine monastery
- Gardens, Library, exhibitions
- Tours available (€15-20)

### Practical

**Getting There**
- Vaporetto Line 2 from San Zaccaria
- 2 minutes
- Every 10-12 minutes

**Time Needed**: 1 hour (church + campanile)

**Best Time**: Sunset — campanile stays open late, facing west toward Venice

**Tip**: Go here instead of San Marco campanile. Better view (includes San Marco in panorama), no wait, same price.
