# Venice Local Services

## Essentials

### Tourist Information
- **Main Office**: Piazza San Marco (Procuratie Nuove)
- **Train Station**: Santa Lucia
- **Airport**: Marco Polo arrivals
- **Website**: veneziaunica.it

### Luggage Storage
- **Train Station**: €6-10/piece/day
- **Piazzale Roma**: Luggage deposit services
- **Hotels**: Usually hold bags before check-in/after checkout

---

## Money

### Banks & ATMs
**Major banks**:
- Unicredit
- Intesa Sanpaolo
- Banca Monte dei Paschi

**ATM tips**:
- Use bank ATMs (not standalone machines)
- Decline "conversion" — use local currency
- €3-5 foreign card fee typical
- Withdraw larger amounts less frequently

**Exchange**: Avoid airport/tourist area bureaux (bad rates)

### Credit Cards
- Widely accepted
- Visa/Mastercard standard
- American Express sometimes
- Some small bacari/shops cash only

---

## Communication

### Phone & SIM
**Options**:
- TIM, Vodafone, Wind Tre — stores throughout
- Tourist SIM: €15-30 for data + calls
- EU roaming: Free for EU phones

**WiFi**:
- Hotels: Usually free
- Cafés: Less common than other cities
- Public: Limited city WiFi

### Post
- **Poste Italiane**: Standard Italian mail
- **Vatican stamps**: Popular for postcards
- **Mailboxes**: Red (regular), blue (priority)

---

## Shopping Hours

### Standard
- **Morning**: 9/10am - 12:30/1pm
- **Lunch closure**: 1-3:30pm (traditional)
- **Afternoon**: 3:30-7/7:30pm

### Tourist Areas
- Often stay open through lunch
- Sundays: Many open
- Later closing in summer

### Closed
- **Sunday**: Some shops, many local businesses
- **Monday morning**: Some shops
- **August**: Many local shops close for vacation

---

## Markets

### Rialto Market
- **Fish (Pescheria)**: Tue-Sat, 7am-12pm
- **Produce (Erberia)**: Tue-Sat, 7am-1pm
- **Closed**: Sun, Mon

### Other Markets
- Small alimentari (grocery shops) throughout
- Supermarkets near Piazzale Roma

---

## Supermarkets

### In Venice
- **Coop**: Near Piazzale Roma
- **Conad**: Various locations
- **Despar/Eurospar**: Smaller format stores
- **Punto Simply**: Near train station

### Hours
- Usually 8am-8pm
- Some close for lunch
- Sunday: Reduced hours or closed

---

## Pharmacies (Farmacie)

### Finding One
- Green cross sign
- "Farmacia" signs
- Rotation system for nights/Sundays

### Services
- OTC medications
- Minor health advice
- Prescription fulfillment
- First aid supplies

### 24-Hour Pharmacies
Check "farmacia di turno" (rotating duty pharmacy) at any pharmacy door

---

## Healthcare

### Emergency
- **118**: Medical emergency
- **112**: General emergency

### Hospital
**Ospedale Civile SS. Giovanni e Paolo**
- Campo SS. Giovanni e Paolo, Castello
- Main hospital for Venice
- Emergency department (Pronto Soccorso)

### Clinics
- Private clinics available for non-emergencies
- Many doctors speak English
- Pharmacists can advise on minor issues

### Insurance
- EU citizens: EHIC/GHIC for emergency care
- Non-EU: Travel insurance essential
- Private care available

---

## Religious Services

### Catholic Mass
- Daily masses at most churches
- Sunday Mass widely available
- San Marco: Tourist-heavy but available

### Other Faiths
- **Jewish**: Synagogues in Ghetto
- **Anglican**: St. George's, Campo San Vio
- **Greek Orthodox**: San Giorgio dei Greci
- **Muslim**: No central mosque; prayer rooms available

---

## Laundry

### Self-Service
- Limited in historic center
- More options near station/Piazzale Roma
- €4-8 wash, €4-6 dry

### Hotel Service
- Most hotels offer (expensive)
- €3-5 per item typical

### Dry Cleaning
- "Lavanderia" or "Tintoria"
- Limited in tourist areas

---

## Public Toilets

### Locations
- Major tourist areas (San Marco, Rialto, Accademia)
- Vaporetto stations (some)
- Train station

### Cost
- €1.50 typically
- Venezia Unica card sometimes includes

### Alternatives
- Cafés (buy something first)
- Museums (with entry)
- Hotels (if staying)

---

## Accessibility Services

### Challenge
Venice is extremely difficult for mobility impairments:
- 400+ bridges with steps
- No ramps on most
- Cobblestones everywhere
- Vaporetti have boarding gaps

### Resources
- **Venezia Accessibile**: Accessible route maps
- **ACTV**: Some accessible vaporetti (Line 5.2)
- **Water taxis**: Best option for wheelchairs

### Tips
- Contact hotels specifically about accessibility
- Consider Giudecca or Lido (flatter)
- Water taxi eliminates most issues (expensive)

---

## Useful Apps

### Transport
- **ACTV**: Official vaporetto app, real-time arrivals
- **Venezia Unica**: Tickets, passes, booking

### Tide/Weather
- **Hi!Tide Venice**: Acqua alta forecasts
- **Acqua Alta Venezia**: Tide predictions

### Navigation
- **Google Maps**: Works but slow in alleys
- **Citymapper**: Less useful than other cities

### Dining
- **TripAdvisor**: Useful for avoiding traps
- **TheFork**: Restaurant reservations
- **Google Maps**: Reviews, hours

---

## Consular Services

### Embassies
Most embassies are in Rome. Limited consular services in Venice.

### Venice Consulates
Check your country's embassy website for:
- Honorary consuls in Venice
- Emergency services
- Nearest full consulate (often Milan or Rome)

### Lost Passport
1. File police report
2. Contact embassy
3. Get emergency travel document

---

## Other Services

### Hair/Beauty
- Salons throughout (closed Monday typical)
- No appointment often OK
- Prices similar to mainland

### Bike/Car Rental
- **In Venice**: None (no cars/bikes in historic center)
- **Lido**: Bike rental available
- **Mainland**: Normal car rental at airport/Mestre

### Photography
- Camera shops in San Marco area
- Memory cards, batteries available
- Tripod technically needs permit (rarely enforced)

### Newspapers
- International papers at station, San Marco newsstands
- Italian papers everywhere (Corriere, Repubblica)

### Religious Items
- Shops near San Marco, Vatican items
- Rosaries, icons, souvenirs

---

## Important Numbers

| Service | Number |
|---------|--------|
| General emergency | 112 |
| Medical emergency | 118 |
| Police (Carabinieri) | 112 |
| Fire | 115 |
| Coast guard | 1530 |
| ACTV (transport) | 041 041 |
| Taxi (water taxi) | 041 522 2303 |
